Using lowercase `l` in literal suffixes can be confusing as it closely resembles the number `1`.
Prefer using uppercase `L` to enhance readability and avoid misinterpretation.

# What Does This Check Look For?

This check reports a finding when a lowercase `l` is used as a suffix in numeric literals, suggesting the use of its uppercase counterpart, `L`.

# Why is This a Problem?

Using a lowercase `l` as a literal suffix might lead to confusion and potential misunderstanding of the code since it closely resembles the digit `1`. 

# How Can I Resolve This?

Replace lowercase `l` with uppercase `L` in literal suffixes.

# Examples

## Non-Compliant

```java
long a = 123l; // non-compliant: lowercase 'l' can be mistaken for '1'
```

## Compliant

```java
long a = 123L; // compliant: The 'L' clearly indicates a long literal
```

# Where Can I Learn More?

- [SEI CERT Oracle C Coding Standard: DCL16-C. Use "L," not "l," to indicate a long value](https://wiki.sei.cmu.edu/confluence/pages/viewpage.action?pageId=87152241)