Declaring multiple variables in a single statement can make code harder to read and maintain.
Each variable should be declared in a separate statement for better clarity.

# What Does This Check Look For?

This check detects instances where multiple variables are declared or initialized in a single statement.

# Why is This a Problem?

Declaring multiple variables in a single statement can reduce the readability and maintainability of the code.
It can make it difficult to spot type mismatches, initialization errors, or to modify a single variable's declaration without affecting others.

# How Can I Resolve This?

Declare or initialize each variable in its own statement.
This approach improves code readability by clearly presenting each variable and its initialization value separately, making it easier to understand and modify.

# Examples

## Non-Compliant

```cpp
int a, b, c;   // non-compliant: multiple declarations in one statement
int x=1, y=1, z=2, w=3;  // non-compliant: multiple initializations in one statement
```

## Compliant

```cpp
int a;
int b;
int c;
int x = 1;
int y = 1;
int z = 2;
int w = 3;
```

# Where Can I Learn More?

- [SEI CERT C Coding Standard: DCL04-C. Do not declare more than one variable per declaration](https://wiki.sei.cmu.edu/confluence/display/c/DCL04-C.+Do+not+declare+more+than+one+variable+per+declaration)