``` python
# Python 2 only:
print 'Hello'
```
  
``` python
# Python 2 and 3:
print('Hello')
```
  
To print multiple strings, import ``print_function`` to prevent Py2 from interpreting it as a tuple:
``` python
# Python 2 only:
print 'Hello', 'Guido'
```
  
``` python
# Python 2 and 3:
from __future__ import print_function    # (at top of module)

print('Hello', 'Guido')
```
  
``` python
# Python 2 only:
print >> sys.stderr, 'Hello'
```
  
``` python
# Python 2 and 3:
from __future__ import print_function

print('Hello', file=sys.stderr)
```
  
``` python
# Python 2 only:
print 'Hello',
```
  
``` python
# Python 2 and 3:
from __future__ import print_function

print('Hello', end='')
```
  

See also [Cheat Sheet: Writing Python 2-3 compatible code](http://python-future.org/compatible_idioms.html)

[Copyright (c) 2013-2016 Python Charmers Pty Ltd, Australia](https://github.com/PythonCharmers/python-future/blob/master/LICENSE.txt)