Having identifiers that differ only in their casing can lead to confusion.
Ensure all identifiers have distinctly different names, not just in casing.

# What Does This Check Look For?

This check identifies cases where identifiers within the same code file only differ by the casing of letters.

# Why is This a Problem?

Using variable or method names that differ only in casing can significantly harm code readability and maintainability. It can confuse developers, especially in cases where the programming language being used is case-sensitive. This can lead to errors that are hard to detect or debug, as developers might use one identifier thinking it refers to another. Furthermore, in environments or languages that are not case-sensitive, such naming could lead to unexpected behavior or runtime errors.

# How Can I Resolve This?

To resolve this issue, refactor the names of affected identifiers to ensure they are distinct and descriptive beyond just letter casing. Consider appending or changing parts of the name to more accurately describe its purpose or relationship within the code. This enhances code readability and reduces the potential for confusion or errors.

# Examples

## Non-Compliant

```java
class Example {
    String userName;
    String UserName; // non-compliant: Only differs in casing from the previous variable
}
```

## Compliant

```java
class Example {
    String userName;
    String userDisplayName; // compliant: Distinctly named
}
```
