import{_ as a,c as t,ak as o,o as i}from"./chunks/framework.AfHpRKMk.js";const u=JSON.parse('{"title":"Feature Version Updates","description":"","frontmatter":{"title":"Feature Version Updates"},"headers":[],"relativePath":"howto/updating-teamscale/feature-version/index.md","filePath":"howto/updating-teamscale/feature-version/index.md"}'),n={name:"howto/updating-teamscale/feature-version/index.md"};function s(r,e,d,l,c,h){return i(),t("div",null,[...e[0]||(e[0]=[o('<h1 id="how-to-perform-a-feature-version-update" tabindex="-1">How to Perform a Feature Version Update <a class="header-anchor" href="#how-to-perform-a-feature-version-update" aria-label="Permalink to &quot;How to Perform a Feature Version Update&quot;">​</a></h1><p>Feature version updates are updates where one of the first two parts of the version number changed. For example, an update from version <strong>9.3</strong>.3 to <strong>9.4</strong>.0 would be considered a feature version update.</p><div class="tip custom-block"><p class="custom-block-title">Avoid Downtimes with a Shadow Instance</p><p>For large instances, we recommend you use a <a href="./../shadow-instance/">shadow instance</a> to perform these updates. This avoids unnecessary downtimes during the update process.</p></div><div class="warning custom-block"><p class="custom-block-title">Re-analysis required</p><p>As the format of the internal database may change and also new checks become available, a full analysis is required after a feature version update.</p><p>This may take some time, depending on the amount of data you have imported into Teamscale (code, findings, coverage, ...). For large instances, we strongly recommend you perform the update with a <a href="./../shadow-instance/">shadow instance</a>.</p></div><h2 id="default-admin-account" tabindex="-1">Default Admin Account <a class="header-anchor" href="#default-admin-account" aria-label="Permalink to &quot;Default Admin Account&quot;">​</a></h2><p>When starting an empty Teamscale instance, only the default user is available. You can log in as <code>admin</code> using the default password <code>admin</code>. When you import a backup and have not changed the default password, Teamscale will delete the default user. This is a security measure to prevent unauthorized access. If you import a backup while logged in as the default admin, make sure the backup contains an admin account to not lock yourself out. If this has happened, you can start Teamscale with the <a href="./../../../reference/administration-ts-installation/#jvm-settings-jvm-properties">JVM property</a> <code>-Dcom.teamscale.force-create-admin</code>. This will recreate the default admin account, so you log in again as <code>admin</code> using the default password <code>admin</code>.</p><h2 id="docker-deployments" tabindex="-1">Docker Deployments <a class="header-anchor" href="#docker-deployments" aria-label="Permalink to &quot;Docker Deployments&quot;">​</a></h2><p>The following steps are specific for <a href="./../../installing-with-docker/">using Docker to deploy Teamscale</a> and are based on our <a href="https://github.com/cqse/teamscale-docker-deployment" target="_blank" rel="noreferrer">reference configuration</a>.</p><p>The detailed steps are as follows:</p><ol><li>Perform a <a href="./../../handling-backups/">full backup export</a> of the configuration and external data via the Backup tab of the Admin perspective.</li><li>Add a new directory named according to the version, e.g. <code>v7.8</code>.</li><li>Copy the config directory (containing <code>teamscale.license</code> and <code>teamscale.properties</code> ) from the production instance to <code>v7.8</code> and adjust any configuration (e.g. workers, memory)</li><li>Add a new service entry in docker-compose.yml, e.g. by coping the entry from v7.7 adjust the image to the new release, e.g. <code>cqse/teamscale:7.8.latest</code> change the volume mount to the newly created folder, e.g. <code>./v7.8/:/var/teamscale/</code></li><li>Reference the <code>v7.8</code> Docker service in the staging server section of <code>nginx/teamscale.conf</code> (<code>set $teamscale_next v7.8;</code>)</li><li>Start the <code>v7.8</code> Docker service using <code>sudo ./start.sh</code>. Now you should have an empty Teamscale instance. Login as <code>admin</code> using the default password <code>admin</code>.</li><li>Import the backup ZIP file into this instance via the Backup page of the Admin perspective.</li><li>If you were using the default settings during backup import, the instance will now be in <a href="./../../../reference/admin-settings/server-settings/#shadow-mode">Shadow Mode</a> which means that no external events, such as notification emails of voting to other production systems will happen.</li><li>You will be logged out because Teamscale deletes the default admin account during backup import. Login in again with any admin account contained in the backup.</li><li>Wait for the analysis to complete.</li><li>If required, disable the Shadow Mode now to make Teamscale send notifications and votes again.</li><li>Update the production server section of <code>nginx/teamscale.conf</code> to reference the previous staging Teamscale server (e,g. <code>set $teamscale_prod v7.8;</code>)</li><li>Reload the nginx configuration by executing sudo <code>./nginx-reload.sh</code></li></ol><h2 id="zip-based-installations" tabindex="-1">Zip-based Installations <a class="header-anchor" href="#zip-based-installations" aria-label="Permalink to &quot;Zip-based Installations&quot;">​</a></h2><p>The following steps are specific for zip-based installations and do not apply if you are using Docker to deploy Teamscale.</p><div class="warning custom-block"><p class="custom-block-title">Always Unzip on Target System</p><p>Always unzip the downloaded ZIP file on the system that you want to install Teamscale on. Otherwise, if the ZIP is, for example, unzipped under Windows and then copied to Linux, Teamscale may later fail to start (as Unix permissions like <em>executable</em> can get lost).</p></div><div class="warning custom-block"><p class="custom-block-title">Do not copy/extract the new Teamscale files over the old ones</p><p>Copying/Extracting the new Teamscale files over the old ones is not supported and will break your installation, e.g. by overwriting configuration changes you have made or by not removing old files that should be deleted during the update. You should instead always unzip the new Teamscale files into a separate directory and copy your configuration files from the old directory as described below.</p></div><p>The detailed steps are as follows:</p><ol><li><p>Perform a <a href="./../../handling-backups/">full backup export</a> of the configuration and external data via the Backup tab of the Admin perspective.</p></li><li><p>Stop Teamscale. This depends on how you installed Teamscale and may require you to stop a service or kill the Teamscale process.</p></li><li><p>It is strongly recommended to create a backup of the Teamscale installation and storage directories, so you can return to the current version if anything does not work as expected.</p></li><li><p>Replace the Teamscale installation with the new one. For this you should rename/remove the old Teamscale installation directory and extract the new version to the same place Teamscale was installed before. If you delete the old directory, make sure to keep the <code>config</code> folder and to copy it back to the new directory. Under Windows, do the same for the <code>windows</code> folder. After extraction, the overall file layout should look the same as before.</p></li><li><p>Also delete the storage directory, if this is outside of your Teamscale installation directory. In case you have configured an external data directory (workspace), make sure to delete this as well.</p></li><li><p>Copy the config files from the previous version to the config folder of the newly extracted version. Under Windows, do the same for the files in the windows folder. You might need to adjust the configuration if the format changed. This will be described at the download site of Teamscale if required.</p></li><li><p>Start Teamscale. Depending on the installation this may require starting the corresponding service or running the start script.</p></li><li><p>Now you should have an empty Teamscale instance. Login as <code>admin</code> using the default password <code>admin</code>.</p></li><li><p>Import the backup ZIP file into this instance via the Backup page of the Admin perspective.</p></li><li><p>If you were using the default settings during backup import, the instance will now be in <a href="./../../../reference/admin-settings/server-settings/#shadow-mode">Shadow Mode</a> which means that no external events, such as notification emails of voting to other systems will happen.</p></li><li><p>You will be logged out because Teamscale deletes the default admin account during backup import. Login in again with any admin account contained in the backup.</p></li><li><p>Wait for the analysis to complete.</p></li><li><p>If required, disable the Shadow Mode now to make Teamscale send notifications and votes again.</p></li></ol>',16)])])}const m=a(n,[["render",s]]);export{u as __pageData,m as default};
