import{_ as o,c as r,ak as l,O as t,z as e,L as p,o as d,b as s,x as i}from"./chunks/framework.AfHpRKMk.js";const c="/assets/test-executions.Rhp6BxAb.png",g="/assets/test-wise-coverage.C-cfFfCx.png",f=JSON.parse('{"title":"Test Impact Analysis for Java","description":"","frontmatter":{},"headers":[],"relativePath":"tutorial/tia-java/index.md","filePath":"tutorial/tia-java/index.md"}'),E={name:"tutorial/tia-java/index.md"};function F(y,a,u,m,C,b){const k=p("ZipDownload"),n=p("PluginTabsTab"),h=p("PluginTabs");return d(),r("div",null,[a[8]||(a[8]=l('<h1 id="test-impact-analysis-for-java" tabindex="-1">Test Impact Analysis for Java <a class="header-anchor" href="#test-impact-analysis-for-java" aria-label="Permalink to &quot;Test Impact Analysis for Java&quot;">​</a></h1><p>This tutorial will show you how to set up Test Impact Analysis (TIA) for the most simple Java project with <strong>Gradle</strong> and <strong>JUnit 5</strong>. It will teach you how to use the <a href="./../../reference/integrations/gradle-plugin/">Teamscale Gradle plugin</a> and configure it for the TIA so it uploads Testwise Coverage and controls which tests are run in your CI/CD pipeline. We will then run through several common code changes and learn how the TIA handles them.</p><nav class="table-of-contents"><ul><li><a href="#tia-setup">TIA Setup</a><ul><li><a href="#step-0-importing-the-project-into-teamscale">Step 0: Importing the Project into Teamscale</a></li><li><a href="#step-1-adding-the-teamscale-plugin">Step 1: Adding the Teamscale Plugin</a></li><li><a href="#step-2-collecting-testwise-coverage-for-all-tests">Step 2: Collecting Testwise Coverage for All Tests</a></li><li><a href="#step-3-uploading-testwise-coverage-to-teamscale">Step 3: Uploading Testwise Coverage to Teamscale</a></li></ul></li><li><a href="#common-tia-scenarios">Common TIA Scenarios</a><ul><li><a href="#step-4-if-we-change-one-method-only-the-corresponding-tests-are-run">Step 4: If We Change One Method, Only the Corresponding Tests Are Run</a></li><li><a href="#step-5-if-a-test-case-fails-once-it-is-rerun-until-it-succeeds">Step 5: If a Test Case Fails Once, It Is Rerun Until It Succeeds</a></li><li><a href="#step-6-if-we-add-a-new-test-case-it-is-always-run">Step 6: If We Add a New Test Case, It Is Always Run</a></li><li><a href="#step-7-what-about-refactorings">Step 7: What about Refactorings?</a></li><li><a href="#step-8-what-happens-if-teamscale-is-offline">Step 8: What Happens if Teamscale is Offline?</a></li></ul></li></ul></nav><h2 id="tia-setup" tabindex="-1">TIA Setup <a class="header-anchor" href="#tia-setup" aria-label="Permalink to &quot;TIA Setup&quot;">​</a></h2><p>This tutorial is based on <a href="https://github.com/cqse/tia-tutorial-gradle-junit5" target="_blank" rel="noreferrer">this very simple Java project hosted on GitHub</a>. During the tutorial, you&#39;ll need to make changes to this repository and push them to GitHub. Thus, please <a href="https://github.com/cqse/tia-tutorial-gradle-junit5/fork" target="_blank" rel="noreferrer">fork</a> it to your own GitHub account and clone it to your local machine:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clone</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> https://github.com/</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">path-to-your-rep</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">o</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span></span></code></pre></div><p>We have already done every step of this tutorial for you. The result each step of this tutorial has a corresponding Git branch in the repository. Each branch builds on the branch of the previous step. So if you&#39;d like to see what, for example, step 5 should look like, simply run <code>git checkout step5</code>.</p><details class="details custom-block"><summary>What to do when forking is not possible</summary><p>If you cannot fork the project, you can use our project but keep in mind that you cannot push to GitHub then. In order for TIA to work correctly in this scenario, you can&#39;t do the changes yourself, but you have to check out the branches for the individual steps. When inspecting the coverage in Teamscale, you will also have to <a href="./../../reference/ui/general-ui-features/#project-and-branch-setting">select the corresponding branch</a>.</p></details><p>To see all the changes made to the project between two steps, simply run a <code>git diff</code>:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> diff</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step1</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step2</span></span></code></pre></div><p>Initially, <code>master</code> is checked out, which contains our unmodified Java project. The project contains one class <code>Calculator</code> and its corresponding JUnit 5 test class <code>CalculatorTest</code>.</p><p>You can run these existing tests with <code>./gradlew clean check</code>. Notice that it runs both test cases.</p><h3 id="step-0-importing-the-project-into-teamscale" tabindex="-1">Step 0: Importing the Project into Teamscale <a class="header-anchor" href="#step-0-importing-the-project-into-teamscale" aria-label="Permalink to &quot;Step 0: Importing the Project into Teamscale&quot;">​</a></h3><p>Before we can do anything in the Gradle project, we first need to import it into Teamscale. If you haven&#39;t done so already, please <a href="/getting-started/installing-teamscale/#downloading-teamscale">download, install and start Teamscale</a>.</p><p>Next, please download the following Teamscale backup:</p>',15)),t(k,{title:"Teamscale Backup for This Tutorial",link:"/assets/tutorial/tia-java/teamscale-backup.zip"}),a[9]||(a[9]=l('<p>It simply sets the <code>admin</code> user&#39;s <a href="./../../glossary/#access-key"><em>access key</em></a> so you don&#39;t need to adjust that in the Gradle script at every step of the tutorial. To this end, <a href="/howto/handling-backups/#importing-backups">import the backup into Teamscale</a>.</p><p>Finally, <a href="/howto/creating-a-project/#creating-the-project">create a Teamscale project</a> for the Git repository that you forked above.</p><ul><li>Name the project <code>tia-junit5</code> (this value is later used in the Gradle scripts).</li><li>Use Teamscale&#39;s default Java analysis profile.</li><li>Set the <em>Branching Configuration</em> to <code>.*</code> &gt; <code>2020-01-01</code></li><li>Add a <em>Git</em> <em>Source Code Repository</em> connector and in its settings add an account and enter the URL <code>https://github.com/&lt;path-to-your-repo&gt;</code>. You can freely choose any name for the account, and you can leave username and password empty.</li><li>Enable the option <code>Enable branch analysis</code> so Teamscale analyzes all branches of the repository.</li><li>Set the polling interval to 1 (second) to make sure Teamscale always knows about the latest code changes for this tutorial.</li><li>Leave all other options at their default values.</li></ul><p>Save the project. You can then go to the <em>Metrics</em> perspective in Teamscale and examine the imported source code.</p><h3 id="step-1-adding-the-teamscale-plugin" tabindex="-1">Step 1: Adding the Teamscale Plugin <a class="header-anchor" href="#step-1-adding-the-teamscale-plugin" aria-label="Permalink to &quot;Step 1: Adding the Teamscale Plugin&quot;">​</a></h3><div class="tip custom-block"><p class="custom-block-title">Inspect Changes Made in This Step</p><p>To see the changes performed in this step, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> diff</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/master</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step1</span></span></code></pre></div></div><p>The <code>com.teamscale</code> plugin will record Testwise Coverage and allows you to easily configure TIA for your project. We will now add it to our Java project.</p><p>We apply and configure the plugin, so it knows where our Teamscale instance is running and how to access it. For a reference of all configuration options, see the <a href="./../../reference/integrations/gradle-plugin/#configuring-the-teamscale-extension">Teamscale Gradle Plugin documentation</a>. Add the following to the body of <code>build.gradle(.kts)</code>:</p>',8)),t(h,{sharedStateKey:"gradle_lang"},{default:e(()=>[t(n,{label:"Groovy"},{default:e(()=>[...a[0]||(a[0]=[s("div",{class:"language-groovy vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"groovy"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"plugins {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    id "),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"com.teamscale"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," version "),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"35.0.2"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")]),i(`
`),s("span",{class:"line"}),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    server {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        url "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "http://localhost:8080/"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        userName "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "admin"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        userAccessToken "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "q4tu9vfAAjQZ1peCpPvQHSrLi5CeIcGY"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        project "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "tia-junit5"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),t(n,{label:"Kotlin DSL"},{default:e(()=>[...a[1]||(a[1]=[s("div",{class:"language-kotlin vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"kotlin"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"plugins"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    id"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"com.teamscale"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},") version "),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"35.0.2"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")]),i(`
`),s("span",{class:"line"}),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    server"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        url "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "http://localhost:8080/"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        userName "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "admin"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        userAccessToken "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "q4tu9vfAAjQZ1peCpPvQHSrLi5CeIcGY"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        project "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "tia-junit5"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1})]),_:1}),a[10]||(a[10]=l(`<p>This configuration will be used by all Gradle tasks that run the TIA or upload to Teamscale.</p><p>In a multi-module Gradle setup, you would usually apply the plugin to each module by adding it to your convention plugin.</p><h3 id="step-2-collecting-testwise-coverage-for-all-tests" tabindex="-1">Step 2: Collecting Testwise Coverage for All Tests <a class="header-anchor" href="#step-2-collecting-testwise-coverage-for-all-tests" aria-label="Permalink to &quot;Step 2: Collecting Testwise Coverage for All Tests&quot;">​</a></h3><div class="tip custom-block"><p class="custom-block-title">Inspect Changes Made in This Step</p><p>To see the changes performed in this step, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> diff</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step1</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step2</span></span></code></pre></div></div><div class="tip custom-block"><p class="custom-block-title">Skip Previous Steps</p><p>To continue with the tutorial from this point, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> checkout</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> master</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> merge</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step1</span></span></code></pre></div></div><p>Before we can run the TIA, we first need to <em>once</em> collect Testwise Coverage for <em>all</em> our tests. This ensures that Teamscale knows about every existing test and its coverage.</p><p>To be able to do this, we have to configure the <code>test</code> task to collect Testwise Coverage for us. Add the following to the body of <code>build.gradle</code>:</p>`,7)),t(h,{sharedStateKey:"gradle_lang"},{default:e(()=>[t(n,{label:"Groovy"},{default:e(()=>[...a[2]||(a[2]=[s("div",{class:"language-groovy vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"groovy"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"import"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," com.teamscale.reporting.testwise.TestwiseCoverageReport")]),i(`
`),s("span",{class:"line"}),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"tasks"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"register("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'testwiseCoverageReport'"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"TestwiseCoverageReport"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},") {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    executionData(tasks"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"test)")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")]),i(`
`),s("span",{class:"line"}),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"tasks"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"test {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    useJUnitPlatform()")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    finalizedBy(tasks"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"testwiseCoverageReport)")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    jacoco {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        includes "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," ["),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"tia.*"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"]")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    teamscale {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        collectTestwiseCoverage "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," true")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),t(n,{label:"Kotlin DSL"},{default:e(()=>[...a[3]||(a[3]=[s("div",{class:"language-kotlin vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"kotlin"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"import"),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}}," com.teamscale.reporting.testwise.TestwiseCoverageReport")]),i(`
`),s("span",{class:"line"}),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"val"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," testwiseCoverageReport "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"by"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," tasks."),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"registering"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"(TestwiseCoverageReport::"),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"class"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},") {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    executionData"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"(tasks.test)")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")]),i(`
`),s("span",{class:"line"}),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"tasks."),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"test"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    useJUnitPlatform"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"()")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    finalizedBy"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"(testwiseCoverageReport)")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    configure"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"<"),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"JacocoTaskExtension"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"> {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        includes "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}}," listOf"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"tia.*"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},")")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    configure"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"<"),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"TeamscaleTaskExtension"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"> {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        collectTestwiseCoverage "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," true")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1})]),_:1}),a[11]||(a[11]=l('<p>The <code>test</code> task will execute all our tests by default. We also set an <code>include</code> pattern so only our code is profiled and not the libraries that we or our test framework use.</p><div class="tip custom-block"><p class="custom-block-title">Always Set Include Patterns</p><p>By setting include patterns, you ensure that only <em>your</em> code is profiled. This makes your tests run faster and the resulting coverage report file smaller. Always set &quot;include&quot; patterns so only <em>your</em> packages are being profiled.</p></div><p>The <code>collectTestwiseCoverage</code> option will make the <code>test</code> task produces coverage data in binary form. The <code>testwiseCoverageReport</code> task will pick up this data and convert it into a Testwise Coverage report.</p><div class="tip custom-block"><p class="custom-block-title">Running a Subset of Your Tests with TIA</p><p><code>collectTestwiseCoverage</code> is <code>false</code> by default. Unit tests are usually fast enough that you don&#39;t need to use TIA on them. But maybe your automated end-to-end tests benefit from the reduced run-time that TIA provides instead.</p></div><p>Try out the new task by running</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span></span></code></pre></div><p>A Testwise Coverage report has now been generated for both of our test cases in <code>build/reports/testwise-coverage/testwiseCoverageReport.json</code>. Open it in your favourite editor and see that it contains our two test cases, their respective test coverage, whether the tests failed or passed and how long it took to run them.</p><h3 id="step-3-uploading-testwise-coverage-to-teamscale" tabindex="-1">Step 3: Uploading Testwise Coverage to Teamscale <a class="header-anchor" href="#step-3-uploading-testwise-coverage-to-teamscale" aria-label="Permalink to &quot;Step 3: Uploading Testwise Coverage to Teamscale&quot;">​</a></h3><p>Next, we&#39;ll upload this information to Teamscale. For this, we define another task:</p>',9)),t(h,{sharedStateKey:"gradle_lang"},{default:e(()=>[t(n,{label:"Groovy"},{default:e(()=>[...a[4]||(a[4]=[s("div",{class:"language-groovy vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"groovy"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"import"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," com.teamscale.TeamscaleUpload")]),i(`
`),s("span",{class:"line"}),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"tasks"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"register("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'teamscaleTestUpload'"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"TeamscaleUpload"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},") {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    partition "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "Unit Tests"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    from(tasks"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"testwiseCoverageReport)")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),t(n,{label:"Kotlin DSL"},{default:e(()=>[...a[5]||(a[5]=[s("div",{class:"language-kotlin vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"kotlin"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"import"),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}}," com.teamscale.TeamscaleUpload")]),i(`
`),s("span",{class:"line"}),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"tasks."),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"register"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"<"),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"TeamscaleUpload"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"teamscaleTestUpload"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},") {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    partition "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "Unit Tests"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    from"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"(tasks."),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"named"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"testwiseCoverageReport"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"))")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1})]),_:1}),a[12]||(a[12]=l('<p>If you&#39;re wondering what <code>partition</code> is for, please check <a href="/glossary/#partition">our glossary entry for partitions</a>.</p><p>To perform the upload, we run the command below. <code>--continue</code> instructs Gradle to upload the Testwise Coverage even when a tests would fail.</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span></code></pre></div><p>You can then go to Teamscale and see the results for yourself: Change to the <em>Metrics</em> perspective, then select its <em>Tests</em> view in the sidebar. There you&#39;ll see that Teamscale now knows about our latest test run:</p><p><img src="'+c+'" alt="Our uploaded Testwise Coverage and test run metadata" width="952" height="104" data-zoom="true"></p><div class="tip custom-block"><p class="custom-block-title">Teamscale is Branch-Aware</p><p>Teamscale knows about all the branches in your VCS and will automatically handle test executions for any number of them correctly. So you can, e.g., run tests on a feature branch, and when you merge it to master, Teamscale will automatically take care to also merge your Testwise Coverage and test results.</p></div><p>If you click on the <code>CalculatorTest</code>, you&#39;ll see all test cases of that class. After clicking on one of them, you can see further details like a treemap with that test case&#39;s Testwise Coverage and the test run metadata that the Testwise Coverage report contained:</p><p><img src="'+g+`" alt="Details for one test case" width="1128" height="889" data-zoom="true"></p><h2 id="common-tia-scenarios" tabindex="-1">Common TIA Scenarios <a class="header-anchor" href="#common-tia-scenarios" aria-label="Permalink to &quot;Common TIA Scenarios&quot;">​</a></h2><p>In this part, we&#39;ll go through several common scenarios to showcase how the TIA intelligently selects tests in each of them to minimize test runtime while also maximizing the number of bugs found by your tests.</p><h3 id="step-4-if-we-change-one-method-only-the-corresponding-tests-are-run" tabindex="-1">Step 4: If We Change One Method, Only the Corresponding Tests Are Run <a class="header-anchor" href="#step-4-if-we-change-one-method-only-the-corresponding-tests-are-run" aria-label="Permalink to &quot;Step 4: If We Change One Method, Only the Corresponding Tests Are Run&quot;">​</a></h3><div class="tip custom-block"><p class="custom-block-title">Inspect Changes Made in This Step</p><p>To see the changes performed in this step, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> diff</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step3</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step4</span></span></code></pre></div></div><div class="tip custom-block"><p class="custom-block-title">Skip Previous Steps</p><p>To continue with the tutorial from this point, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> checkout</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> master</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> merge</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step3</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span></code></pre></div></div><p>To enable TIA for our <code>test</code> task we set the <code>runImpacted</code> property to <code>true</code> in our task definition. <code>runImpacted</code> instructs the plugin to only run the test cases that Teamscale reports as <em>impacted</em> by our changes. By default, it considers all recent changes, since the tests have been executed last time. Additionally, we need to set the <code>partition</code> to <code>&quot;Unit Tests&quot;</code> to tell Teamscale, from which partition we would like to have tests suggested.</p>`,14)),t(h,{sharedStateKey:"gradle_lang"},{default:e(()=>[t(n,{label:"Groovy"},{default:e(()=>[...a[6]||(a[6]=[s("div",{class:"language-groovy vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"groovy"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"tasks"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"test {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"    // ...")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    teamscale {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        collectTestwiseCoverage "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," true")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        runImpacted "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," true")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        partition "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "Unit Tests"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),t(n,{label:"Kotlin DSL"},{default:e(()=>[...a[7]||(a[7]=[s("div",{class:"language-kotlin vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"kotlin"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"tasks."),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"test"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"    // ...")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    configure"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"<"),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"TeamscaleTaskExtension"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"> {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        collectTestwiseCoverage "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," true")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        runImpacted "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," true")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        partition "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "Unit Tests"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1})]),_:1}),a[13]||(a[13]=l(`<p>Now let&#39;s see TIA in action! We&#39;ll change the method <code>Calculator.sumImpl()</code> which is called by <code>Calculator.sum()</code>. This change only affects one of our two test cases: <code>CalculatorTest.testSum()</code> so we&#39;d expect the TIA to only run that test and not <code>CalculatorTest.testMinus()</code>.</p><p>Let&#39;s introduce a not-so-subtle bug in the method:</p><div class="language-java vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">java</span><pre class="shiki shiki-themes github-light github-dark has-diff vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">public</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> int</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> sum</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> a, </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> b) {</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    return</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> sumImpl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(a, b);</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">private</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> int</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> sumImpl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> a, </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> b) {</span></span>
<span class="line diff add"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    a </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> a </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">*</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 5</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">; </span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    return</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> a </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">+</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> b;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>Commit and push the changes.</p><p>Now let&#39;s run TIA.</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span></code></pre></div><div class="tip custom-block"><p class="custom-block-title">Always Upload Testwise Coverage</p><p>We recommend always running the upload task after executing impacted tests. This keeps Teamscale&#39;s TIA data up to date. The data is recorded either way, so there is no reason not to make use of it!</p></div><p>Gradle&#39;s test summary on the console shows, as we expected, that only one test was executed while the other was ignored in this test run. And it found the bug we introduced.</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> Task :test FAILED</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">JUnit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> Jupiter</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> testSum</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">FAILED</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">    org.opentest4j.AssertionFailedError</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> at</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest.java:11</span></span>
<span class="line"></span>
<span class="line highlighted"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">1</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> completed,</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 1</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> failed</span></span></code></pre></div><h3 id="step-5-if-a-test-case-fails-once-it-is-rerun-until-it-succeeds" tabindex="-1">Step 5: If a Test Case Fails Once, It Is Rerun Until It Succeeds <a class="header-anchor" href="#step-5-if-a-test-case-fails-once-it-is-rerun-until-it-succeeds" aria-label="Permalink to &quot;Step 5: If a Test Case Fails Once, It Is Rerun Until It Succeeds&quot;">​</a></h3><div class="tip custom-block"><p class="custom-block-title">Inspect Changes Made in This Step</p><p>To see the changes performed in this step, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> diff</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step4</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step5</span></span></code></pre></div></div><div class="tip custom-block"><p class="custom-block-title">Skip Previous Steps</p><p>To continue with the tutorial from this point, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> checkout</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> master</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> merge</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step4</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span></code></pre></div></div><p>In the last step, we made some changes to our code that made a test case fail. The TIA picked this up and ran the test case as expected. However, what happens when we now do some unrelated changes that don&#39;t fix the test failure? What we <strong>don&#39;t</strong> want to happen is that TIA now ignores the failing test case. After all, it still needs attention. Let&#39;s try this out: Let&#39;s change the message of the <code>println</code> in the <code>minus()</code> method:</p><div class="language-java vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">java</span><pre class="shiki shiki-themes github-light github-dark has-diff vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">public</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> int</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> minus</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> a, </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> b) {</span></span>
<span class="line diff remove"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    System.out.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">println</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;gi&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">); </span></span>
<span class="line diff add"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    System.out.</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">println</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;tia rocks&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">); </span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    return</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> a </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">-</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> b;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>Commit and push the changes.</p><p>Normally, TIA would only run the <code>testMinus()</code> test case as the <code>testSum()</code> test case is not affected by this change. However, since <code>testSum()</code> failed the last time we ran it, it is re-run this time again:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span>
<span class="line"></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> Task :test FAILED</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">JUnit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> Jupiter</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> testSum</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">FAILED</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">    org.opentest4j.AssertionFailedError</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> at</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest.java:11</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">JUnit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> Jupiter</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> testMinus</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">PASSED</span></span>
<span class="line"></span>
<span class="line highlighted"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">2</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> tests</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> completed,</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 1</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> failed</span></span></code></pre></div><h3 id="step-6-if-we-add-a-new-test-case-it-is-always-run" tabindex="-1">Step 6: If We Add a New Test Case, It Is Always Run <a class="header-anchor" href="#step-6-if-we-add-a-new-test-case-it-is-always-run" aria-label="Permalink to &quot;Step 6: If We Add a New Test Case, It Is Always Run&quot;">​</a></h3><div class="tip custom-block"><p class="custom-block-title">Inspect Changes Made in This Step</p><p>To see the changes performed in this step, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> diff</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step5</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step6</span></span></code></pre></div></div><div class="tip custom-block"><p class="custom-block-title">Skip Previous Steps</p><p>To continue with the tutorial from this point, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> checkout</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> master</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> merge</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step5</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span></code></pre></div></div><p>Let&#39;s undo the change that causes the test failure and also add a new test case for the <code>sum()</code> method. This will cause the <code>testSum()</code> test to be re-run. At the same time, let&#39;s add a new test-case for the <code>minus()</code> method:</p><div class="language-java vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">java</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">@</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Test</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">public</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> void</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> testMinus2</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() {</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">    assertEquals</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">-</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">new</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> Calculator</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">().</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">minus</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">, </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">2</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">));</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>Commit and push the changes.</p><p>How does TIA deal with newly added test cases? After all, it doesn&#39;t know yet what coverage this test will produce. So we&#39;d expect it to always run any new test cases, just in case they might fail:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span>
<span class="line"></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> Task :test</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">JUnit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> Jupiter</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> testSum</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">PASSED</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">JUnit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> Jupiter</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> testMinus2</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">PASSED</span></span></code></pre></div><p>As you can see, both the test case for the modified <code>sum()</code> method is run and our new <code>testMinus2()</code>. All this is to ensure that we don&#39;t miss any bugs that our newly modified test cases would have caught.</p><h3 id="step-7-what-about-refactorings" tabindex="-1">Step 7: What about Refactorings? <a class="header-anchor" href="#step-7-what-about-refactorings" aria-label="Permalink to &quot;Step 7: What about Refactorings?&quot;">​</a></h3><div class="tip custom-block"><p class="custom-block-title">Inspect Changes Made in This Step</p><p>To see the changes performed in this step, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> diff</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step6</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step7</span></span></code></pre></div></div><div class="tip custom-block"><p class="custom-block-title">Skip Previous Steps</p><p>To continue with the tutorial from this point, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> checkout</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> master</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> merge</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step6</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span></code></pre></div></div><p>If we just use the IDE to refactor some code, there&#39;s really no need to re-run its test cases. Most importantly, if we rename something, TIA should detect that this is not an actual test-worthy change but just a rename refactoring. Let&#39;s try it by renaming some method parameters:</p><div class="language-java vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">java</span><pre class="shiki shiki-themes github-light github-dark has-diff vp-code" tabindex="0"><code><span class="line diff remove"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">public</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> int</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> sum</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> a, </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> b) { </span></span>
<span class="line diff add"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">public</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> int</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> sum</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> first, </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> second) { </span></span>
<span class="line diff remove"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    return</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> sumImpl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(a, b); </span></span>
<span class="line diff add"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    return</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> sumImpl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(first, second); </span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>Commit and push the changes.</p><p>Now run TIA again:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span>
<span class="line"></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">BUILD</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> SUCCESSFUL</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> in</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> 2s</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">6</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> actionable</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> tasks:</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 6</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> executed</span></span></code></pre></div><p>As you can see, no tests were executed as nothing test-worthy changed in the system. The same is true for non-code changes like adding or removing whitespace or changing code comments.</p><h3 id="step-8-what-happens-if-teamscale-is-offline" tabindex="-1">Step 8: What Happens if Teamscale is Offline? <a class="header-anchor" href="#step-8-what-happens-if-teamscale-is-offline" aria-label="Permalink to &quot;Step 8: What Happens if Teamscale is Offline?&quot;">​</a></h3><div class="tip custom-block"><p class="custom-block-title">Inspect Changes Made in This Step</p><p>To see the changes performed in this step, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> diff</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step7</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step8</span></span></code></pre></div></div><div class="tip custom-block"><p class="custom-block-title">Skip Previous Steps</p><p>To continue with the tutorial from this point, run</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> checkout</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> master</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">git</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> merge</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> origin/step7</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span></code></pre></div></div><p>One important failure case to think about is: what if your build server can&#39;t reach your Teamscale instance? This might e.g., happen when your network isn&#39;t working, someone changed the firewall rules by accident, or someone shut down Teamscale for some maintenance work. In neither case do you want your CI/CD pipeline to crash and stop working! So let&#39;s simulate this:</p><p><strong>Simply kill the Teamscale process in your task manager.</strong></p><p>In this step, we change the <code>sumImpl()</code> method and introduce another bug:</p><div class="language-java vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">java</span><pre class="shiki shiki-themes github-light github-dark has-diff vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    private</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> int</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> sumImpl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">(</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> a, </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">int</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> b) {</span></span>
<span class="line diff remove"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">        return</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> a </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">+</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> b; </span></span>
<span class="line diff add"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">        return</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> a </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">-</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> b; </span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span></code></pre></div><p>Commit and push the changes.</p><p>If TIA were running, it would re-run only the tests for <code>sum()</code>. Let&#39;s see what happens now that Teamscale is offline:</p><div class="language-sh vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">sh</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./gradlew</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> clean</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span>
<span class="line"></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> Task :test FAILED</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">JUnit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> Jupiter</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> testSum</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">FAILED</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">    org.opentest4j.AssertionFailedError</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> at</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest.java:11</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">JUnit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> Jupiter</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> testMinus</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">PASSED</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">JUnit</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> Jupiter</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> CalculatorTest</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> testMinus2</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">() </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">PASSED</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">3</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> tests</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> completed,</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 1</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> failed</span></span></code></pre></div><p>As you can see, the <code>com.teamscale</code> plugin simply ran all tests. This is the default behavior, in case anything goes wrong, including when Teamscale is not reachable. In that case, your CI/CD pipeline will just safely revert to its old behavior so you don&#39;t miss any bugs.</p>`,46))])}const B=o(E,[["render",F]]);export{f as __pageData,B as default};
