/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.service.framework.impl.provider.FunctionalConverter;
import com.teamscale.service.framework.impl.provider.InvalidValueException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectIdBase;

@Provider
public class IProjectIdConverterProvider
implements ParamConverterProvider {
    public <P> ParamConverter<P> getConverter(Class<P> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(IProjectId.class)) {
            return new FunctionalConverter(annotations, IProjectIdConverterProvider::convert);
        }
        return null;
    }

    private static IProjectId convert(String projectId) throws InvalidValueException {
        try {
            return ProjectIdBase.convert((String)projectId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidValueException(e.getMessage(), e);
        }
    }
}

