/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.util;

import com.teamscale.core.rest.IMultiPartFormDataProvider;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.glassfish.jersey.internal.util.collection.ImmutableMultivaluedMap;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.message.internal.MediaTypes;

public class JaxRsFormDataProvider
implements IMultiPartFormDataProvider {
    private final ContainerRequestContext requestContext;
    private final Providers providers;
    private final MediaType requestMediaType;
    private final boolean isSupportedMediaType;

    public JaxRsFormDataProvider(ContainerRequestContext requestContext, Providers providers) {
        this.requestContext = requestContext;
        this.providers = providers;
        this.requestMediaType = requestContext.getMediaType();
        this.isSupportedMediaType = MediaTypes.typeEqual((MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MediaType)this.requestMediaType) || MediaTypes.typeEqual((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE, (MediaType)this.requestMediaType);
    }

    public Optional<String> getParameter(String parameterName) {
        if (!this.requestContext.hasEntity() || !this.isSupportedMediaType) {
            return Optional.empty();
        }
        try {
            if (MediaTypes.typeEqual((MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE, (MediaType)this.requestMediaType)) {
                return this.getFormParameter(parameterName);
            }
            if (MediaTypes.typeEqual((MediaType)MediaType.MULTIPART_FORM_DATA_TYPE, (MediaType)this.requestMediaType)) {
                return this.getMultiPartParameter(parameterName);
            }
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        return Optional.empty();
    }

    private Optional<String> getFormParameter(String name) throws IOException {
        MultivaluedMap<String, String> form = this.getFormParameters();
        List values = (List)form.get((Object)name);
        if (values == null) {
            return Optional.empty();
        }
        return values.stream().findFirst();
    }

    public MultivaluedMap<String, String> getFormParameters() throws IOException {
        return this.extractEntity(Form.class).asMap();
    }

    private Optional<String> getMultiPartParameter(String name) throws IOException {
        FormDataMultiPart form = this.extractEntity(FormDataMultiPart.class);
        return Optional.ofNullable(form.getField(name)).map(FormDataBodyPart::getValue);
    }

    private <T> T extractEntity(Class<T> entityType) throws IOException {
        ByteArrayInputStream resettableIS = JaxRsFormDataProvider.toResettableStream(this.requestContext.getEntityStream());
        Object form = this.providers.getMessageBodyReader(entityType, entityType, new Annotation[0], this.requestMediaType).readFrom(entityType, entityType, new Annotation[0], this.requestMediaType, (MultivaluedMap)ImmutableMultivaluedMap.empty(), (InputStream)resettableIS);
        resettableIS.reset();
        this.requestContext.setEntityStream((InputStream)resettableIS);
        return (T)form;
    }

    private static ByteArrayInputStream toResettableStream(InputStream entityStream) throws IOException {
        return new ByteArrayInputStream(FileSystemUtils.readStreamBinary((InputStream)entityStream));
    }
}

