/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.smartnotifications;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.sonarsource.sonarlint.core.serverconnection.storage.SmartNotificationsStorage;
import org.sonarsource.sonarlint.core.storage.StorageService;

public class LastEventPolling {
    private final StorageService storage;

    public LastEventPolling(StorageService storage) {
        this.storage = storage;
    }

    public ZonedDateTime getLastEventPolling(String connectionId, String projectKey) {
        Optional<Long> lastEventPollingEpoch = this.storage.connection(connectionId).project(projectKey).smartNotifications().readLastEventPolling();
        return lastEventPollingEpoch.map(aLong -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(aLong), ZoneId.systemDefault())).orElseGet(ZonedDateTime::now);
    }

    public void setLastEventPolling(ZonedDateTime dateTime, String connectionId, String projectKey) {
        SmartNotificationsStorage smartNotificationsStorage = this.storage.connection(connectionId).project(projectKey).smartNotifications();
        Optional<Long> lastEventPolling = smartNotificationsStorage.readLastEventPolling();
        long dateTimeEpoch = dateTime.toInstant().toEpochMilli();
        if (lastEventPolling.isPresent() && dateTimeEpoch <= lastEventPolling.get()) {
            return;
        }
        smartNotificationsStorage.store(dateTimeEpoch);
    }
}

