/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry.payload;

import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.telemetry.OffsetDateTimeAdapter;
import org.sonarsource.sonarlint.core.telemetry.payload.HotspotPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.IssuePayload;
import org.sonarsource.sonarlint.core.telemetry.payload.ShowHotspotPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.ShowIssuePayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TaintVulnerabilitiesPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryAnalyzerPerformancePayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryHelpAndFeedbackPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryNotificationsPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.TelemetryRulesPayload;
import org.sonarsource.sonarlint.core.telemetry.payload.cayc.CleanAsYouCodePayload;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;
import org.sonarsource.sonarlint.shaded.com.google.gson.GsonBuilder;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonElement;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonObject;
import org.sonarsource.sonarlint.shaded.com.google.gson.annotations.SerializedName;
import org.sonarsource.sonarlint.shaded.com.google.gson.reflect.TypeToken;

public class TelemetryPayload {
    @SerializedName(value="days_since_installation")
    private final long daysSinceInstallation;
    @SerializedName(value="days_of_use")
    private final long daysOfUse;
    @SerializedName(value="sonarlint_version")
    private final String version;
    @SerializedName(value="sonarlint_product")
    private final String product;
    @SerializedName(value="ide_version")
    private final String ideVersion;
    @SerializedName(value="platform")
    private final String platform;
    @SerializedName(value="architecture")
    private final String architecture;
    @SerializedName(value="connected_mode_used")
    private final boolean connectedMode;
    @SerializedName(value="connected_mode_sonarcloud")
    private final boolean connectedModeSonarcloud;
    @SerializedName(value="system_time")
    private final OffsetDateTime systemTime;
    @SerializedName(value="install_time")
    private final OffsetDateTime installTime;
    @SerializedName(value="os")
    private final String os;
    @SerializedName(value="jre")
    private final String jre;
    @SerializedName(value="nodejs")
    private final String nodejs;
    @SerializedName(value="analyses")
    private final TelemetryAnalyzerPerformancePayload[] analyses;
    @SerializedName(value="server_notifications")
    private final TelemetryNotificationsPayload notifications;
    @SerializedName(value="show_hotspot")
    private final ShowHotspotPayload showHotspotPayload;
    @SerializedName(value="show_issue")
    private final ShowIssuePayload showIssuePayload;
    @SerializedName(value="taint_vulnerabilities")
    private final TaintVulnerabilitiesPayload taintVulnerabilitiesPayload;
    @SerializedName(value="rules")
    private final TelemetryRulesPayload telemetryRulesPayload;
    @SerializedName(value="hotspot")
    private final HotspotPayload hotspotPayload;
    @SerializedName(value="issue")
    private final IssuePayload issuePayload;
    @SerializedName(value="help_and_feedback")
    private final TelemetryHelpAndFeedbackPayload helpAndFeedbackPayload;
    @SerializedName(value="cayc")
    private final CleanAsYouCodePayload cleanAsYouCodePayload;
    private final transient Map<String, Object> additionalAttributes;

    public TelemetryPayload(long daysSinceInstallation, long daysOfUse, String product, String version, String ideVersion, @Nullable String platform, @Nullable String architecture, boolean connectedMode, boolean connectedModeSonarcloud, OffsetDateTime systemTime, OffsetDateTime installTime, String os, String jre, @Nullable String nodejs, TelemetryAnalyzerPerformancePayload[] analyses, TelemetryNotificationsPayload notifications, ShowHotspotPayload showHotspotPayload, ShowIssuePayload showIssuePayload, TaintVulnerabilitiesPayload taintVulnerabilitiesPayload, TelemetryRulesPayload telemetryRulesPayload, HotspotPayload hotspotPayload, IssuePayload issuePayload, TelemetryHelpAndFeedbackPayload helpAndFeedbackPayload, CleanAsYouCodePayload cleanAsYouCodePayload, Map<String, Object> additionalAttributes) {
        this.daysSinceInstallation = daysSinceInstallation;
        this.daysOfUse = daysOfUse;
        this.product = product;
        this.version = version;
        this.ideVersion = ideVersion;
        this.platform = platform;
        this.architecture = architecture;
        this.connectedMode = connectedMode;
        this.connectedModeSonarcloud = connectedModeSonarcloud;
        this.systemTime = systemTime;
        this.installTime = installTime;
        this.os = os;
        this.jre = jre;
        this.nodejs = nodejs;
        this.analyses = analyses;
        this.notifications = notifications;
        this.showHotspotPayload = showHotspotPayload;
        this.showIssuePayload = showIssuePayload;
        this.taintVulnerabilitiesPayload = taintVulnerabilitiesPayload;
        this.telemetryRulesPayload = telemetryRulesPayload;
        this.hotspotPayload = hotspotPayload;
        this.issuePayload = issuePayload;
        this.helpAndFeedbackPayload = helpAndFeedbackPayload;
        this.cleanAsYouCodePayload = cleanAsYouCodePayload;
        this.additionalAttributes = additionalAttributes;
    }

    public long daysSinceInstallation() {
        return this.daysSinceInstallation;
    }

    public long daysOfUse() {
        return this.daysOfUse;
    }

    public TelemetryAnalyzerPerformancePayload[] analyses() {
        return this.analyses;
    }

    public String version() {
        return this.version;
    }

    public String product() {
        return this.product;
    }

    public boolean connectedMode() {
        return this.connectedMode;
    }

    public boolean connectedModeSonarcloud() {
        return this.connectedModeSonarcloud;
    }

    public String os() {
        return this.os;
    }

    public String jre() {
        return this.jre;
    }

    public String nodejs() {
        return this.nodejs;
    }

    public OffsetDateTime systemTime() {
        return this.systemTime;
    }

    public TelemetryNotificationsPayload notifications() {
        return this.notifications;
    }

    public TelemetryHelpAndFeedbackPayload helpAndFeedbackPayload() {
        return this.helpAndFeedbackPayload;
    }

    public CleanAsYouCodePayload cleanAsYouCodePayload() {
        return this.cleanAsYouCodePayload;
    }

    public IssuePayload issuePayload() {
        return this.issuePayload;
    }

    public Map<String, Object> additionalAttributes() {
        return this.additionalAttributes;
    }

    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)OffsetDateTime.class), new OffsetDateTimeAdapter()).create();
        JsonObject jsonPayload = gson.toJsonTree(this).getAsJsonObject();
        JsonObject jsonAdditional = gson.toJsonTree(this.additionalAttributes, new TypeToken<Map<String, Object>>(){}.getType()).getAsJsonObject();
        return gson.toJson(TelemetryPayload.mergeObjects(jsonAdditional, jsonPayload));
    }

    static JsonObject mergeObjects(JsonObject source, JsonObject target) {
        for (Map.Entry<String, JsonElement> entry : source.entrySet()) {
            JsonElement value = entry.getValue();
            if (!target.has(entry.getKey())) {
                target.add(entry.getKey(), value);
                continue;
            }
            if (!value.isJsonObject()) continue;
            JsonObject valueJson = (JsonObject)value;
            TelemetryPayload.mergeObjects(valueJson, target.getAsJsonObject(entry.getKey()));
        }
        return target;
    }
}

