/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpandableStringCharactersTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.HeredocStringLiteralTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonarsource.analyzer.commons.EntropyDetector;
import org.sonarsource.analyzer.commons.HumanLanguageDetector;

@Rule(key="S6418")
public class HardCodedSecretCheck
extends PHPVisitorCheck {
    private static final String DEFAULT_SECRET_WORDS = "api[_.-]?key,auth,credential,secret,token";
    private static final String DEFAULT_RANDOMNESS_SENSIBILITY = "5.0";
    private static final double LANGUAGE_SCORE_INCREMENT = 0.3;
    private static final int MAX_RANDOMNESS_SENSIBILITY = 10;
    private static final int MINIMUM_CREDENTIAL_LENGTH = 17;
    private static final String FIRST_ACCEPTED_CHARACTER = "[\\w.+/~$:&-]";
    private static final String FOLLOWING_ACCEPTED_CHARACTER = "[=\\w.+/~$:&-]";
    private static final Pattern SECRET_PATTERN = Pattern.compile("[\\w.+/~$:&-]([=\\w.+/~$:&-]|\\\\\\\\[=\\w.+/~$:&-])++");
    private static final Pattern IP_PATTERN = Pattern.compile("%s|%s".formatted("(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[1-9])(\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}(?!\\d)", "\\[?(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7})|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))(?![\\d\\w:])"));
    @RuleProperty(key="secretWords", description="Comma separated list of words identifying potential secrets", defaultValue="api[_.-]?key,auth,credential,secret,token")
    public String secretWords = "api[_.-]?key,auth,credential,secret,token";
    @RuleProperty(key="randomnessSensibility", description="Allows to tune the Randomness Sensibility (from 0 to 10)", defaultValue="5.0")
    public double randomnessSensibility = Double.parseDouble("5.0");
    private List<Pattern> variablePatterns;
    private List<Pattern> literalPatterns;
    private EntropyDetector entropyDetector;
    private double maxLanguageScore;

    @Override
    public void visitVariableDeclaration(VariableDeclarationTree tree) {
        Object object = tree.initValue();
        if (object instanceof LiteralTree) {
            LiteralTree literalTree = (LiteralTree)object;
            this.detectSecret(tree.identifier().text(), CheckUtils.trimQuotes(literalTree.value()), literalTree);
        }
        if ((object = tree.initValue()) instanceof HeredocStringLiteralTree) {
            HeredocStringLiteralTree heredoc = (HeredocStringLiteralTree)object;
            for (ExpandableStringCharactersTree heredocLine : heredoc.strings()) {
                this.detectSecret(tree.identifier().text(), heredocLine.value(), heredocLine);
            }
        }
        super.visitVariableDeclaration(tree);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String functionName = CheckUtils.getLowerCaseFunctionName(tree);
        if ("define".equals(functionName)) {
            this.visitDefineFunctionCall(tree);
        } else if ("strcasecmp".equals(functionName) || "strcmp".equals(functionName)) {
            this.visitStringCompareFunctionCall(tree);
        } else if (tree.callArguments().size() == 2) {
            this.visitTwoArgumentsFunctionCall(tree);
        }
        super.visitFunctionCall(tree);
    }

    private void visitDefineFunctionCall(FunctionCallTree tree) {
        CheckUtils.argumentValue(tree, "constant_name", 0).filter(constantName -> constantName.is(Tree.Kind.REGULAR_STRING_LITERAL)).map(LiteralTree.class::cast).ifPresent(constantName -> CheckUtils.argumentValue(tree, "value", 1).filter(value -> value.is(Tree.Kind.REGULAR_STRING_LITERAL)).map(LiteralTree.class::cast).ifPresent(value -> this.detectSecret(CheckUtils.trimQuotes(constantName.value()), CheckUtils.trimQuotes(value.value()), (Tree)value)));
    }

    private void visitStringCompareFunctionCall(FunctionCallTree tree) {
        VariableIdentifierTree variableIdentifier;
        ExpressionTree callArg;
        Optional<LiteralTree> string1 = CheckUtils.resolvedArgumentLiteral(tree, "string1", 0);
        Optional<LiteralTree> string2 = CheckUtils.resolvedArgumentLiteral(tree, "string2", 1);
        if (string1.isPresent() && tree.callArguments().size() == 2 && (callArg = ((CallArgumentTree)tree.callArguments().get(1)).value()) instanceof VariableIdentifierTree) {
            variableIdentifier = (VariableIdentifierTree)callArg;
            this.detectSecret(variableIdentifier.text(), string1.get().value(), string1.get());
        }
        if (string2.isPresent() && tree.callArguments().size() == 2 && (callArg = ((CallArgumentTree)tree.callArguments().get(0)).value()) instanceof VariableIdentifierTree) {
            variableIdentifier = (VariableIdentifierTree)callArg;
            this.detectSecret(variableIdentifier.text(), string2.get().value(), string2.get());
        }
    }

    private void visitTwoArgumentsFunctionCall(FunctionCallTree tree) {
        ExpressionTree firstArg = ((CallArgumentTree)tree.callArguments().get(0)).value();
        ExpressionTree secondArg = ((CallArgumentTree)tree.callArguments().get(1)).value();
        if (firstArg instanceof LiteralTree) {
            LiteralTree firstLiteralTree = (LiteralTree)firstArg;
            if (secondArg instanceof LiteralTree) {
                LiteralTree secondLiteralTree = (LiteralTree)secondArg;
                this.detectSecret(firstLiteralTree.value(), secondLiteralTree.value(), secondLiteralTree);
                this.detectSecret(secondLiteralTree.value(), firstLiteralTree.value(), firstLiteralTree);
            }
        }
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree variableIdentifier = tree.variable();
        if (variableIdentifier instanceof VariableIdentifierTree) {
            VariableIdentifierTree identifier = (VariableIdentifierTree)variableIdentifier;
            ExpressionTree valueTree = tree.value();
            if (valueTree instanceof LiteralTree) {
                LiteralTree literalTree = (LiteralTree)valueTree;
                this.detectSecret(identifier.text(), literalTree.value(), literalTree);
            }
        }
        super.visitAssignmentExpression(tree);
    }

    @Override
    public void visitParameter(ParameterTree tree) {
        ExpressionTree expressionTree = tree.initValue();
        if (expressionTree instanceof LiteralTree) {
            LiteralTree valueTree = (LiteralTree)expressionTree;
            this.detectSecret(tree.variableIdentifier().text(), valueTree.value(), valueTree);
        }
        super.visitParameter(tree);
    }

    @Override
    public void visitArrayPair(ArrayPairTree tree) {
        ExpressionTree expressionTree = tree.key();
        if (expressionTree instanceof LiteralTree) {
            LiteralTree keyTree = (LiteralTree)expressionTree;
            expressionTree = tree.value();
            if (expressionTree instanceof LiteralTree) {
                LiteralTree valueTree = (LiteralTree)expressionTree;
                this.detectSecret(keyTree.value(), valueTree.value(), valueTree);
            }
        }
        super.visitArrayPair(tree);
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        VariableIdentifierTree variableTree;
        LiteralTree secretValueTree;
        ExpressionTree leftOperand = tree.leftOperand();
        ExpressionTree rightOperand = tree.rightOperand();
        if (rightOperand instanceof LiteralTree) {
            secretValueTree = (LiteralTree)rightOperand;
            if (leftOperand instanceof VariableIdentifierTree) {
                variableTree = (VariableIdentifierTree)leftOperand;
                this.detectSecret(variableTree.text(), secretValueTree.value(), rightOperand);
            }
        }
        if (leftOperand instanceof LiteralTree) {
            secretValueTree = (LiteralTree)leftOperand;
            if (rightOperand instanceof VariableIdentifierTree) {
                variableTree = (VariableIdentifierTree)rightOperand;
                this.detectSecret(variableTree.text(), secretValueTree.value(), leftOperand);
            }
        }
        super.visitBinaryExpression(tree);
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        String literal = CheckUtils.trimQuotes(tree.value());
        this.literalPatterns().map(pattern -> pattern.matcher(literal)).filter(Matcher::find).filter(matcher -> !HardCodedSecretCheck.isExcludedLiteral(matcher.group("suffix"))).findAny().ifPresent(matcher -> this.reportIssue(tree, matcher.group(1)));
        super.visitLiteral(tree);
    }

    private void detectSecret(String identifierName, String secretValue, Tree tree) {
        String identifier = CheckUtils.trimQuotes(identifierName);
        String secret = CheckUtils.trimQuotes(secretValue);
        this.getSecretLikeName(identifier).ifPresent(secretName -> {
            if (this.isSecret(secret)) {
                this.reportIssue(tree, (String)secretName);
            }
        });
    }

    private void reportIssue(Tree tree, String secretName) {
        this.newIssue(tree, "'%s' detected in this expression, review this potentially hard-coded secret.".formatted(secretName));
    }

    private Optional<String> getSecretLikeName(String identifierName) {
        if (identifierName.isBlank()) {
            return Optional.empty();
        }
        return this.variableSecretPatterns().map(pattern -> pattern.matcher(identifierName)).filter(Matcher::find).map(matcher -> matcher.group(1)).findAny();
    }

    private Stream<Pattern> variableSecretPatterns() {
        if (this.variablePatterns == null) {
            this.variablePatterns = this.toPatterns("");
        }
        return this.variablePatterns.stream();
    }

    private Stream<Pattern> literalPatterns() {
        if (this.literalPatterns == null) {
            this.literalPatterns = this.toPatterns("=\\s*+(?<suffix>[^\\\\ &;#,|]+)");
        }
        return this.literalPatterns.stream();
    }

    private List<Pattern> toPatterns(String suffix) {
        return Stream.of(this.secretWords.split(",")).map(String::trim).map(word -> Pattern.compile("(" + word + ")" + suffix, 2)).toList();
    }

    private boolean isSecret(String literal) {
        if (literal.length() < 17 || !SECRET_PATTERN.matcher(literal).matches()) {
            return false;
        }
        return this.isRandom(literal) && HardCodedSecretCheck.isNotIpV6(literal);
    }

    private boolean isRandom(String literal) {
        return this.entropyDetector().hasEnoughEntropy(literal) && HumanLanguageDetector.humanLanguageScore(literal) < this.maxLanguageScore();
    }

    private static boolean isNotIpV6(String literal) {
        return !IP_PATTERN.matcher(literal).matches();
    }

    private static boolean isExcludedLiteral(String followingString) {
        return !HardCodedSecretCheck.isPotentialCredential(followingString) || followingString.startsWith("?") || followingString.startsWith(":") || followingString.contains("%s");
    }

    private static boolean isPotentialCredential(String literal) {
        String trimmed = literal.trim();
        return trimmed.length() >= 17;
    }

    private EntropyDetector entropyDetector() {
        if (this.entropyDetector == null) {
            this.entropyDetector = new EntropyDetector(this.randomnessSensibility);
        }
        return this.entropyDetector;
    }

    private double maxLanguageScore() {
        if (this.maxLanguageScore == 0.0) {
            this.maxLanguageScore = (10.0 - this.randomnessSensibility) * 0.3;
        }
        return this.maxLanguageScore;
    }
}

