/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1821")
public class NestedSwitchCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1821";
    private static final String MESSAGE = "Refactor this code to eliminate this nested \"switch\" statement.";
    private static final String MESSAGE_SECONDARY = "Parent \"switch\" statement";
    private SwitchStatementTree parentSwitchStatement = null;

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        if (this.parentSwitchStatement != null) {
            this.context().newIssue(this, tree.switchToken(), MESSAGE).secondary(this.parentSwitchStatement.switchToken(), MESSAGE_SECONDARY);
        }
        SwitchStatementTree previousParentSwitchStatement = this.parentSwitchStatement;
        this.parentSwitchStatement = tree;
        super.visitSwitchStatement(tree);
        this.parentSwitchStatement = previousParentSwitchStatement;
    }
}

