/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.HashSet;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.symbols.FunctionSymbol;
import org.sonar.php.symbols.Parameter;
import org.sonar.php.symbols.Symbols;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2234")
public class ParameterSequenceCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Parameters to \"%s\" have the same names but not the same order as the method arguments.";
    private static final String SECONDARY_MESSAGE = "Implementation of the parameters sequence.";

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        FunctionSymbol symbol = Symbols.get(tree);
        SeparatedList<CallArgumentTree> arguments = tree.callArguments();
        if (!symbol.isUnknownSymbol() && arguments.size() > 1 && arguments.stream().allMatch(a -> a.name() == null)) {
            this.checkFunctionCall(tree, symbol);
        }
        super.visitFunctionCall(tree);
    }

    private void checkFunctionCall(FunctionCallTree tree, FunctionSymbol symbol) {
        List<String> parameters = symbol.parameters().stream().map(Parameter::name).toList();
        if (ParameterSequenceCheck.isWrongParameterSequence(tree, parameters)) {
            this.newIssue(tree, String.format(MESSAGE, symbol.qualifiedName())).secondary(symbol.location(), SECONDARY_MESSAGE);
        }
    }

    private static boolean isWrongParameterSequence(FunctionCallTree call, List<String> parameters) {
        List<String> arguments = CheckUtils.argumentsOfKind(call, Tree.Kind.VARIABLE_IDENTIFIER).stream().map(e -> ((VariableIdentifierTree)e).text()).toList();
        return arguments.size() == parameters.size() && !arguments.equals(parameters) && new HashSet<String>(parameters).equals(new HashSet<String>(arguments));
    }
}

