/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2046")
public class PerlStyleCommentsUsageCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Use \"//\" instead of \"#\" to start this comment";

    @Override
    public void visitTrivia(SyntaxTrivia trivia) {
        super.visitTrivia(trivia);
        String text = trivia.text();
        if (text.charAt(0) == '#' && !PerlStyleCommentsUsageCheck.isShebangLine(text)) {
            this.context().newIssue(this, trivia, MESSAGE);
        }
    }

    private static boolean isShebangLine(String triviaText) {
        return triviaText.startsWith("#!");
    }
}

