/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S105")
public class TabCharacterCheck
extends PHPVisitorCheck {
    public static final String KEY = "S105";
    private static final String MESSAGE = "Replace all tab characters in this file by sequences of white-spaces.";

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        Stream<String> lines = CheckUtils.lines(this.context().getPhpFile());
        if (lines.anyMatch(line -> line.contains("\t"))) {
            this.context().newFileIssue(this, MESSAGE);
        }
    }
}

