/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.runtime.impl.analysis.ETriggerExecutionResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class DetailedWorkerLog
extends DetailedLogEntryBase {
    private static final long serialVersionUID = 1L;
    private static final String PROCESSOR_STATE_PROPERTY_NAME = "processorState";
    private static final String INPUT_DELTA_ADDED_CHANGED_KEYS_PROPERTY_NAME = "inputDeltaAddedChangedKeys";
    private static final String INPUT_DELTA_DELETED_KEYS_PROPERTY_NAME = "inputDeltaDeletedKeys";
    private static final String SCHEDULING_REASON_PROPERTY_NAME = "schedulingReason";
    private static final String ROLLBACK_ID_PROPERTY_NAME = "rollbackId";
    @JsonProperty(value="processorState")
    private final ETriggerExecutionResult processorState;
    @JsonProperty(value="inputDeltaAddedChangedKeys")
    private final List<String> inputDeltaAddedChangedKeys = new ArrayList<String>();
    @JsonProperty(value="inputDeltaDeletedKeys")
    private final List<String> inputDeltaDeletedKeys = new ArrayList<String>();
    @JsonProperty(value="schedulingReason")
    private final String schedulingReason;
    @JsonProperty(value="rollbackId")
    private final @Nullable UUID rollbackId;

    @JsonCreator
    public DetailedWorkerLog(@JsonProperty(value="id") LogEntryIdentifier id, @JsonProperty(value="loggingEvents") Collection<LoggingEventTransport> loggingEvents, @JsonProperty(value="processorState") ETriggerExecutionResult processorState, @JsonProperty(value="inputDeltaAddedChangedKeys") List<String> inputDeltaAddedChangedKeys, @JsonProperty(value="inputDeltaDeletedKeys") List<String> inputDeltaDeletedKeys, @JsonProperty(value="schedulingReason") String schedulingReason, @JsonProperty(value="rollbackId") UUID rollbackId) {
        super(id, loggingEvents);
        this.processorState = processorState;
        this.inputDeltaAddedChangedKeys.addAll(inputDeltaAddedChangedKeys);
        this.inputDeltaDeletedKeys.addAll(inputDeltaDeletedKeys);
        this.schedulingReason = schedulingReason;
        this.rollbackId = rollbackId;
    }

    public DetailedWorkerLog(LogEntryIdentifier id, Collection<LoggingEventTransport> loggingEvents, ETriggerExecutionResult processorState, List<IIndexDelta> inputDeltas, String schedulingReason, UUID rollbackId) {
        super(id, loggingEvents);
        this.processorState = processorState;
        if (inputDeltas != null) {
            for (IIndexDelta delta : inputDeltas) {
                IndexDelta<String> logDelta = delta.asLogDelta();
                this.inputDeltaAddedChangedKeys.addAll((Collection<String>)logDelta.getAddedOrChangedKeys());
                this.inputDeltaDeletedKeys.addAll((Collection<String>)logDelta.getDeletedKeys());
            }
        }
        this.schedulingReason = schedulingReason;
        this.rollbackId = rollbackId;
    }

    public String getSchedulingReason() {
        return this.schedulingReason;
    }

    @Override
    protected Stream<String> getFilterCriteria() {
        return Stream.concat(super.getFilterCriteria(), Stream.of(this.processorState.name(), this.schedulingReason));
    }
}

