/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.metrics.MetricsIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public class MetricsIndexSynchronizer {
    private final KeyDelta contentChanges;
    private final MetricsIndex metricsIndex;
    private final List<String> partitions = new ArrayList<String>();
    private final List<PairList<String, Serializable>> values = new ArrayList<PairList<String, Serializable>>();

    public MetricsIndexSynchronizer(MetricsIndex metricsIndex, KeyDelta contentChanges) {
        this.metricsIndex = metricsIndex;
        this.contentChanges = contentChanges;
    }

    public void addPartition(String partition, PairList<String, Serializable> values) {
        this.partitions.add(partition);
        this.values.add(values);
    }

    public void addEmptyPartitionIfAbsent(String partition) {
        if (!this.partitions.contains(partition)) {
            this.addPartition(partition, (PairList<String, Serializable>)new PairList());
        }
    }

    public void synchronize() throws StorageException {
        this.metricsIndex.removeEntries(this.contentChanges.getDeletedKeysAsStrings(), this.partitions);
        this.metricsIndex.setMetricValues(this.values, this.partitions);
    }
}

