/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.store;

import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import java.util.Arrays;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStore;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;

class PointwiseMigratingStore
extends DelegatingStore {
    private final IPointwiseStorageMigrator pointWiseMigrator;

    public PointwiseMigratingStore(IStore store, IPointwiseStorageMigrator pointWiseMigrator) {
        super(store);
        this.pointWiseMigrator = pointWiseMigrator;
    }

    private PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        return this.pointWiseMigrator.migrate(key, value);
    }

    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        PairList<byte[], byte[]> keysValues = this.migrate(key, value);
        if (keysValues == null) {
            return;
        }
        for (Pair newKeyValue : keysValues) {
            super.put((byte[])newKeyValue.getFirst(), (byte[])newKeyValue.getSecond());
        }
    }

    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        PairList newKeysValues = new PairList();
        for (int i = 0; i < keysValues.size(); ++i) {
            PairList<byte[], byte[]> migratedKeysValues;
            try {
                migratedKeysValues = this.migrate((byte[])keysValues.getFirst(i), (byte[])keysValues.getSecond(i));
            }
            catch (StorageException e) {
                throw new StorageException("Error migrating value with index " + i + ", entry: " + Arrays.toString((byte[])keysValues.getFirst(i)) + " -> " + Arrays.toString((byte[])keysValues.getSecond(i)), (Throwable)e);
            }
            if (migratedKeysValues == null) continue;
            newKeysValues.addAll(migratedKeysValues);
        }
        super.put(newKeysValues);
    }
}

