/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.options;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="admin.contact.url", name="Admin Contact", type=EOptionType.SERVER, category=EOptionCategory.SERVER, orderingHint=300)
@IndexValueClass(containedInBackup=true)
public class AdminContactUrlOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "admin.contact.url";
    public static final String OPTION_NAME = "Admin Contact";
    @JsonProperty(value="url")
    @OptionFieldDescription(name="Admin contact URL", description="A URL to contact the administrator, e.g. a website (http://support.acme.com) or the admin's mail address (mailto:admin@acme.com)")
    public String url = "";

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        return null;
    }

    public static String getAdministratorContactInformation(GlobalStorageSystem globalStorageSystem) throws StorageException {
        ServerOptionIndex optionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        AdminContactUrlOption adminContactUrlOption = ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, AdminContactUrlOption.class, optionIndex);
        return adminContactUrlOption.url;
    }
}

