/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.options;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="baseurl", name="Teamscale Instance", type=EOptionType.SERVER, category=EOptionCategory.SERVER, orderingHint=100)
@IndexValueClass(containedInBackup=true)
public class BaseUrlOption
implements IOption {
    private static final long serialVersionUID = 1L;
    private static final Set<String> SUPPORTED_PROTOCOLS = new HashSet<String>(Arrays.asList("http", "https"));
    public static final String OPTION_ID = "baseurl";
    public static final String OPTION_NAME = "Teamscale Instance";
    @JsonProperty(value="baseUrl")
    @OptionFieldDescription(name="Instance Base URL", description="This value is used to provide links to Teamscale in, for example, notification emails and integrations into code collaboration platforms.")
    public String baseUrl = "";

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (StringUtils.isEmpty((String)this.baseUrl)) {
            return null;
        }
        try {
            URL url = new URL(this.baseUrl);
            if (!SUPPORTED_PROTOCOLS.contains(url.getProtocol().toLowerCase())) {
                return "Protocol " + url.getProtocol() + " for base URL not supported!";
            }
        }
        catch (MalformedURLException e) {
            return "Invalid base URL: " + e.getMessage();
        }
        return null;
    }

    public static String getBaseUrl(GlobalStorageSystem globalStorageSystem) throws StorageException {
        ServerOptionIndex optionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        return BaseUrlOption.getBaseUrl(optionIndex);
    }

    public static String getBaseUrl(ServerOptionIndex optionIndex) throws StorageException {
        BaseUrlOption option = ServerOptionRegistry.getInstance().getOption("server", OPTION_ID, null, BaseUrlOption.class, optionIndex);
        if (option == null || StringUtils.isEmpty((String)option.baseUrl)) {
            return null;
        }
        return StringUtils.ensureEndsWith((String)option.baseUrl.trim(), (String)"/");
    }
}

