/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;

@Index(name="commit-children", options={EStorageOption.COMMIT_ISOLATED}, valueClasses={CommitDescriptor.class})
public class CommitChildrenIndex
extends IndexBase
implements IRollbackableIndex,
IProjectIndex {
    public static final String NAME = "commit-children";

    public CommitChildrenIndex(IStore store) {
        super(store);
    }

    public static CommitChildrenIndex open(IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        if (SchedulingConstants.isMaintenance(projectId)) {
            return new CommitChildrenIndex((IStore)new InMemoryStore());
        }
        return indexLayer.openNonHistorizedProjectIndex(CommitChildrenIndex.class, projectId);
    }

    public void insertAsChildForParents(ParentedCommitDescriptor childCommit) throws StorageException {
        this.store.performWithLock(() -> {
            ParentedCommitDescriptor child = ParentedCommitDescriptor.cleanCopyOf((ParentedCommitDescriptor)childCommit);
            SetMap updatedValues = new SetMap();
            for (CommitDescriptor parent : child.getParentCommits()) {
                List childrenInParent = (List)((Object)StorageUtils.deserialize((byte[])this.store.get(parent.toBranchTimestampKey())));
                if (childrenInParent != null) {
                    updatedValues.addAll((Object)parent, (Collection)childrenInParent);
                }
                updatedValues.add((Object)parent, (Object)new CommitDescriptor((CommitDescriptor)child));
            }
            PairList<byte[], byte[]> valuesToUpdate = CommitChildrenIndex.serializeEntries((SetMap<CommitDescriptor, CommitDescriptor>)updatedValues);
            this.store.put(valuesToUpdate);
        });
    }

    private static PairList<byte[], byte[]> serializeEntries(SetMap<CommitDescriptor, CommitDescriptor> updatedValues) throws StorageException {
        PairList valuesToUpdate = new PairList(updatedValues.size());
        for (Map.Entry entry : updatedValues) {
            ArrayList value = new ArrayList((Collection)entry.getValue());
            value.sort(CommitDescriptor::compareTo);
            valuesToUpdate.add((Object)((CommitDescriptor)entry.getKey()).toBranchTimestampKey(), (Object)StorageUtils.serialize(value));
        }
        return valuesToUpdate;
    }

    public List<CommitDescriptor> getChildCommits(CommitDescriptor commit) throws StorageException {
        ArrayList result = (ArrayList)StorageUtils.deserialize((byte[])this.store.get(commit.toBranchTimestampKey()));
        if (result == null) {
            return CollectionUtils.emptyList();
        }
        return result;
    }

    private SetMap<CommitDescriptor, CommitDescriptor> getAllEntries() throws StorageException {
        final SetMap allEntries = new SetMap();
        ExceptionHandlingKeyValueCallbackBase scanner = new ExceptionHandlingKeyValueCallbackBase(this){

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                allEntries.addAll((Object)CommitDescriptor.fromBranchTimestampKey((byte[])key), (Collection)((Object)StorageUtils.deserialize((byte[])value)));
            }
        };
        this.store.scan(new byte[0], (IKeyValueCallback)scanner);
        scanner.throwCaughtException();
        return allEntries;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        if (timestampByBranch.isEmpty()) {
            return;
        }
        SetMap<CommitDescriptor, CommitDescriptor> allEntries = this.getAllEntries();
        SetMap updatedEntries = new SetMap();
        ArrayList<byte[]> commitsToDelete = new ArrayList<byte[]>();
        for (Map.Entry entry : allEntries) {
            CommitDescriptor commit = (CommitDescriptor)entry.getKey();
            Long cutOffTimestamp = timestampByBranch.get(commit.getBranchName());
            if (cutOffTimestamp != null && commit.getTimestamp() > cutOffTimestamp) {
                commitsToDelete.add(commit.toBranchTimestampKey());
                continue;
            }
            Set children = (Set)entry.getValue();
            children.removeIf(child -> {
                Long childCutOffTimestamp = (Long)timestampByBranch.get(child.getBranchName());
                return childCutOffTimestamp != null && child.getTimestamp() > childCutOffTimestamp;
            });
            updatedEntries.addAll((Object)commit, (Collection)children);
        }
        this.store.remove(commitsToDelete);
        this.store.put(CommitChildrenIndex.serializeEntries((SetMap<CommitDescriptor, CommitDescriptor>)updatedEntries));
    }
}

