/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.google.common.base.Suppliers;
import com.teamscale.core.analysis.trigger.RollbackRequestedCommitDescriptor;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.RollbackLogMessage;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.RollbackLimitOption;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.CommitChildrenIndex;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.trigger.ITrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.PrivilegedTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgress;
import com.teamscale.core.runtime.impl.project.DeleteProjectTrigger;
import com.teamscale.core.runtime.impl.rollback.ForceRollbackTrigger;
import com.teamscale.core.runtime.impl.rollback.PostponedRollbackIndex;
import com.teamscale.core.runtime.impl.rollback.RollbackTrigger;
import com.teamscale.core.runtime.impl.scheduling.AssignedJobs;
import com.teamscale.core.runtime.impl.scheduling.JobQueue;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.scheduling.SchedulingData;
import com.teamscale.core.runtime.impl.scheduling.TriggerCache;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.collections.DurableIdGenerator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jspecify.annotations.Nullable;

public class SchedulingHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final InternalProjectId internalProjectId;
    private final IndexLayer indexLayer;
    private final SchedulingData globalSchedulingData;
    private final JobQueue jobQueue;
    private final AssignedJobs assignedJobs;
    private final TriggerCache triggerCache;
    private final ProjectAnalysisProgress progress;
    private final DurableIdGenerator idGenerator;

    public SchedulingHelper(InternalProjectId internalProjectId, IndexLayer indexLayer, JobQueue jobQueue, AssignedJobs assignedJobs, TriggerCache triggerCache, ProjectAnalysisProgress progress, DurableIdGenerator idGenerator, SchedulingData globalSchedulingData) throws StorageException {
        this.internalProjectId = internalProjectId;
        this.indexLayer = indexLayer;
        this.globalSchedulingData = globalSchedulingData;
        this.jobQueue = jobQueue;
        this.assignedJobs = assignedJobs;
        this.triggerCache = triggerCache;
        this.progress = progress;
        this.idGenerator = idGenerator;
    }

    public void scheduleJob(JobDescriptor job) {
        this.scheduleJobWithInputDeltas(job, (PairList<String, Long>)PairList.emptyPairList(), (PairList<String, Long>)PairList.emptyPairList(), 0L, 0);
    }

    public void rescheduleJob(ScheduledJob scheduledJob) {
        this.scheduleJobWithInputDeltas(scheduledJob.getJob(), scheduledJob.getInputDeltas(), scheduledJob.getVirtualStores(), scheduledJob.getEarliestScheduleTimestamp(), scheduledJob.getRetryCount());
    }

    public void scheduleJobWithInputDelta(JobDescriptor job, Pair<String, Long> storeAndDeltaId, @Nullable Long virtualStoreId) {
        PairList virtualStores = virtualStoreId == null ? PairList.emptyPairList() : PairList.from((Object)((String)storeAndDeltaId.getFirst()), (Object)virtualStoreId);
        this.scheduleJobWithInputDeltas(job, (PairList<String, Long>)PairList.fromPairs(storeAndDeltaId, (Pair[])new Pair[0]), (PairList<String, Long>)virtualStores, 0L, 0);
    }

    private void scheduleJobWithInputDeltas(JobDescriptor job, PairList<String, Long> inputDeltas, PairList<String, Long> virtualStores, long earliestTimestampToRun, int retryCount) {
        LOGGER.debug("Scheduled new job " + String.valueOf(job));
        try {
            ITrigger trigger = this.triggerCache.getTrigger(job);
            CommitDescriptor schedulingCommit = job.getSchedulingCommit();
            boolean causedRollback = this.checkForRollback(job, trigger, schedulingCommit);
            if (!causedRollback || trigger.preserveInCaseOfRollback()) {
                HashSet requiredDeltas = CollectionUtils.intersectionSet(trigger.getWriteStores(), (Collection[])new Collection[]{this.triggerCache.getAllDeltaStores()});
                ScheduledJob scheduledJob = new ScheduledJob(this.idGenerator.getNextId(), job, requiredDeltas, inputDeltas, virtualStores, earliestTimestampToRun, retryCount);
                this.jobQueue.insertJob(scheduledJob);
                this.progress.updateProgress(job, trigger, schedulingCommit);
            }
        }
        catch (TriggerCompilationException | StorageException e) {
            LOGGER.error("Exception during job scheduling for project " + String.valueOf(this.internalProjectId) + ": " + e.getMessage(), e);
        }
    }

    private boolean checkForRollback(JobDescriptor job, ITrigger trigger, CommitDescriptor schedulingCommit) throws StorageException {
        if (!trigger.canCauseSchedulingConflicts() || !job.isRollbackRelevant()) {
            return false;
        }
        if (RollbackTrigger.class.getName().equals(job.getTriggerName())) {
            return false;
        }
        CommitChildrenIndex commitChildrenIndex = CommitChildrenIndex.open(this.indexLayer, (IProjectId)job.getInternalProjectId());
        Optional<ProjectAnalysisProgress.ConflictInfo> conflictInfo = this.progress.getPotentialConflictInfo(schedulingCommit, trigger.getTransitiveWriteStores(), trigger instanceof PrivilegedTrigger, job.getRollbackId(), commitChildrenIndex);
        if (conflictInfo.isPresent()) {
            this.performRollback(conflictInfo.get(), job);
            return true;
        }
        return false;
    }

    private void performRollback(ProjectAnalysisProgress.ConflictInfo conflictInfo, JobDescriptor rollbackCausingJob) throws StorageException {
        String rollbackMessage = "Performing rollback from " + String.valueOf(conflictInfo.getConflictCommit()) + " to " + String.valueOf(rollbackCausingJob.getSchedulingCommit()) + " in project " + String.valueOf(this.loadPublicProjectId());
        CommitDescriptor rollbackToCommit = rollbackCausingJob.getSchedulingCommit();
        if (ForceRollbackTrigger.class.getName().equals(rollbackCausingJob.getTriggerName())) {
            rollbackMessage = rollbackMessage + ". " + rollbackCausingJob.getSchedulingReason();
        } else {
            rollbackMessage = rollbackMessage + " caused by job " + String.valueOf(rollbackCausingJob) + " due to conflict: " + conflictInfo.getConflictDetails();
            rollbackToCommit = rollbackToCommit.cloneWithDecrementedTimestamp();
        }
        LOGGER.warn((Message)new RollbackLogMessage(rollbackMessage, rollbackCausingJob.getRollbackId()));
        this.scheduleRollback(rollbackToCommit, rollbackMessage, conflictInfo.getRollbackId(), rollbackCausingJob);
    }

    public void scheduleRollback(CommitDescriptor rollbackToCommit, String rollbackMessage, UUID rollbackId) throws StorageException {
        this.scheduleRollback(rollbackToCommit, rollbackMessage, rollbackId, null);
    }

    public void scheduleRollback(CommitDescriptor rollbackToCommit, String rollbackMessage, UUID rollbackId, @Nullable JobDescriptor rollbackJob) throws StorageException {
        if (this.rollbackShouldBePostponed(rollbackToCommit, rollbackJob)) {
            LOGGER.warn((Message)new RollbackLogMessage("Previous rollback to " + String.valueOf(rollbackToCommit) + " was postponed for manual inspection", rollbackId));
            PostponedRollbackIndex postponedRollbackIndex = this.indexLayer.openProjectIndex((IProjectId)this.internalProjectId, PostponedRollbackIndex.class, null);
            postponedRollbackIndex.insertPostponedRollback(rollbackMessage, SchedulingHelper.getRelevantRollbackCommits(rollbackToCommit));
        } else if (rollbackToCommit instanceof RollbackRequestedCommitDescriptor || !this.jobQueue.existsJobForCommit(RollbackTrigger.class.getName(), rollbackToCommit)) {
            this.jobQueue.insertJob(new ScheduledJob(this.idGenerator.getNextId(), new JobDescriptor(this.internalProjectId, RollbackTrigger.class, rollbackToCommit, rollbackMessage, rollbackId)));
            this.progress.setAnalysisState(EAnalysisState.getAnalysisStateAfterRollback(this.progress.getAnalysisState()));
        }
    }

    private static List<CommitDescriptor> getRelevantRollbackCommits(CommitDescriptor rollbackToCommit) {
        if (rollbackToCommit instanceof RollbackRequestedCommitDescriptor) {
            return ((RollbackRequestedCommitDescriptor)rollbackToCommit).getSchedulingHints();
        }
        return Collections.singletonList(rollbackToCommit);
    }

    private boolean rollbackShouldBePostponed(CommitDescriptor rollbackToCommit, @Nullable JobDescriptor rollbackJob) throws StorageException {
        if (rollbackJob != null && ForceRollbackTrigger.class.getName().equals(rollbackJob.getTriggerName())) {
            LOGGER.debug("{}: Not postponing rollback to commit '{}', as it was forced by a user.", new Supplier[]{this::loadPublicProjectId, () -> rollbackToCommit});
            return false;
        }
        if (rollbackToCommit instanceof RollbackRequestedCommitDescriptor && ((RollbackRequestedCommitDescriptor)rollbackToCommit).mayNotBePostponed()) {
            LOGGER.debug("{}: Not postponing rollback to commit '{}', as it may not be postponed.", new Supplier[]{this::loadPublicProjectId, () -> rollbackToCommit});
            return false;
        }
        if (this.isSmallRollback(rollbackToCommit)) {
            LOGGER.debug("{}: Not postponing rollback to commit '{}', as it is small.", new Supplier[]{this::loadPublicProjectId, () -> rollbackToCommit});
            return false;
        }
        List<CommitDescriptor> rollbackCommits = SchedulingHelper.getRelevantRollbackCommits(rollbackToCommit);
        if (CollectionUtils.allMatch(rollbackCommits, PreCommitUtils::isPrecommitCommit)) {
            LOGGER.debug("{}: Not postponing rollback to commit '{}', because only pre-commits are rolled back.", new Supplier[]{this::loadPublicProjectId, () -> rollbackToCommit});
            return false;
        }
        if (this.progress.getAnalysisState() == EAnalysisState.HISTORY_ANALYSIS) {
            LOGGER.debug("{}: Not postponing rollback to commit '{}', as we never reached HEAD before.", new Supplier[]{this::loadPublicProjectId, () -> rollbackToCommit});
            return false;
        }
        return this.rollsBackTooOldCommit(rollbackCommits);
    }

    private boolean rollsBackTooOldCommit(List<CommitDescriptor> rollbackCommits) throws StorageException {
        long limitTimestamp;
        ServerOptionIndex serverOptionIndex = this.indexLayer.openGlobalIndex(ServerOptionIndex.class);
        int maxHours = RollbackLimitOption.getAgeThresholdHours(serverOptionIndex);
        long oldestTimestamp = rollbackCommits.stream().mapToLong(CommitDescriptor::getTimestamp).min().orElseThrow();
        return oldestTimestamp < (limitTimestamp = DateTimeUtils.now().minus(Duration.ofHours(maxHours)).toEpochMilli());
    }

    private boolean isSmallRollback(CommitDescriptor rollbackCommit) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)this.internalProjectId);
        Map<String, Long> timestampForBranch = RollbackTrigger.buildRollbackTimestampForBranchMap(rollbackCommit, projectStorageSystem);
        CounterSet<ECommitTreeNodeState> rolledBackStateCount = RollbackTrigger.determineRolledBackStateCount(projectStorageSystem, timestampForBranch);
        ServerOptionIndex serverOptionIndex = this.indexLayer.openGlobalIndex(ServerOptionIndex.class);
        if (rolledBackStateCount.getValue((Object)ECommitTreeNodeState.PROCESSED) <= RollbackLimitOption.getCommitCountThreshold(serverOptionIndex)) {
            LOGGER.debug("{}: Rollback for commit '{}' has size '{}'", new Supplier[]{this::loadPublicProjectId, () -> rollbackCommit, () -> rolledBackStateCount.getValue((Object)ECommitTreeNodeState.PROCESSED)});
            return true;
        }
        return false;
    }

    public boolean existsJob(String triggerName, CommitDescriptor commitDescriptor, boolean includeAssignedJobs) {
        if (commitDescriptor == null) {
            return includeAssignedJobs && this.assignedJobs.existsJobForTrigger(triggerName) || this.jobQueue.existsJobForTrigger(triggerName);
        }
        return includeAssignedJobs && this.assignedJobs.existsJobForCommit(triggerName, commitDescriptor) || this.jobQueue.existsJobForCommit(triggerName, commitDescriptor);
    }

    public boolean existsJobWithoutSchedulingCommit(String triggerName) {
        return this.jobQueue.existsJobWithoutSchedulingCommit(triggerName);
    }

    public TriggerCache getTriggerCache() {
        return this.triggerCache;
    }

    public JobQueue getJobQueue() {
        return this.jobQueue;
    }

    public ProjectAnalysisProgress getProgress() {
        return this.progress;
    }

    public AssignedJobs getAssignedJobs() {
        return this.assignedJobs;
    }

    public InternalProjectId getInternalProjectId() {
        return this.internalProjectId;
    }

    public PublicProjectId loadPublicProjectId() {
        try {
            return this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)this.internalProjectId);
        }
        catch (StorageException e) {
            throw new IllegalStateException("Could not resolve PublicProjectId for %s".formatted(this.internalProjectId), e);
        }
    }

    public DurableIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public boolean isUnusedDelta(long deltaId) {
        return this.assignedJobs.isUnusedDelta(deltaId) && this.jobQueue.isUnusedDelta(deltaId);
    }

    public boolean isUnusedVirtualStore(long virtualStoreId) {
        return this.assignedJobs.isUnusedVirtualStore(virtualStoreId) && this.jobQueue.isUnusedVirtualStore(virtualStoreId);
    }

    public Optional<ScheduledJob> extractAndAssignNextAssignableJob() throws TriggerCompilationException, StorageException {
        LOGGER.traceEntry("Trying to find next job for project {}", new Supplier[]{this::loadPublicProjectId});
        boolean isDeleting = CollectionUtils.anyMatch(this.assignedJobs.getAllJobs(), job -> DeleteProjectTrigger.class.getName().equals(job.getTriggerName()));
        ScheduledJob nextJob = this.jobQueue.extractNextAssignableJob(isDeleting, (SupplierWithException<Collection<JobDescriptor>, StorageException>)((SupplierWithException)() -> ((com.google.common.base.Supplier)Suppliers.memoize(this.globalSchedulingData::getOverallAssignedJobs)).get()));
        if (nextJob != null) {
            this.assignedJobs.assignJob(nextJob);
            this.progress.updateWrittenStores(nextJob.getSchedulingCommit(), this.triggerCache.getTrigger(nextJob).getWriteStores(), nextJob);
        }
        LOGGER.trace("Found job {} for project {}", new Supplier[]{() -> nextJob, this::loadPublicProjectId});
        return Optional.ofNullable(nextJob);
    }

    public boolean isNonNullSchedulingCommitJobRunningOrReady() {
        return !this.assignedJobs.getAllNonNullSchedulingCommits().isEmpty() || !this.jobQueue.getAllNonNullSchedulingCommits().isEmpty();
    }

    public boolean isSchedulingDeadlock() throws StorageException {
        if (!this.assignedJobs.isEmpty()) {
            return false;
        }
        if (this.jobQueue.isEmpty()) {
            return false;
        }
        if (SchedulingHelper.containsDelayedJobs(this.jobQueue)) {
            return false;
        }
        try {
            return this.jobQueue.pollBestJob(false, (SupplierWithException<Collection<JobDescriptor>, StorageException>)((SupplierWithException)Collections::emptyList)) == null;
        }
        catch (TriggerCompilationException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static boolean containsDelayedJobs(JobQueue jobQueue) {
        long now = System.currentTimeMillis();
        return jobQueue.getAllJobs().stream().anyMatch(scheduledJob -> scheduledJob.getEarliestScheduleTimestamp() > now);
    }

    public String toString() {
        return "Project scheduling helper for project " + String.valueOf(this.internalProjectId);
    }
}

