/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import com.teamscale.core.authenticate.AuthenticationManager;
import com.teamscale.core.authenticate.SecurityUtils;
import com.teamscale.core.authenticate.SessionIndex;
import com.teamscale.core.authenticate.teamscale.HashedStoredPasswordAuthenticator;
import com.teamscale.core.authenticate.teamscale.accesskeys.AccessKey;
import com.teamscale.core.authenticate.teamscale.accesskeys.EncryptedAccessKeyIndex;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserSatisfactionStatusIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class UserUtils {
    public static final String ADMINISTRATOR_GROUP_NAME = "Administrators";
    public static final String ADMIN_USER_NAME = "admin";
    public static final String DEFAULT_ADMIN_USER_PASSWORD = "admin";

    public static void createDefaultUser(IndexLayer indexLayer) throws StorageException {
        UserIndex userIndex = indexLayer.openGlobalIndex(UserIndex.class);
        UserGroupIndex groupIndex = indexLayer.openGlobalIndex(UserGroupIndex.class);
        PermissionIndex permissionIndex = indexLayer.openGlobalIndex(PermissionIndex.class);
        if (!userIndex.isEmpty() && !TeamscaleSystemProperties.FORCE_ADMIN_CREATION.getValue().booleanValue()) {
            return;
        }
        String authenticator = new HashedStoredPasswordAuthenticator().getAuthenticatorIdentifier() + ":" + HashedStoredPasswordAuthenticator.hash(StringUtils.stringToBytes((String)"admin"), null);
        UserGroup adminGroup = groupIndex.getUserGroup(ADMINISTRATOR_GROUP_NAME);
        if (adminGroup == null) {
            adminGroup = new UserGroup(ADMINISTRATOR_GROUP_NAME);
        }
        if (!TeamscaleSystemProperties.PREVENT_ADMIN_CREATION.getValue().booleanValue()) {
            User user = new User("admin", "Default", "Administrator", "", authenticator);
            adminGroup.addUser(user);
            user.addGroup(adminGroup);
            userIndex.setUser(user, indexLayer.getMessageBroker());
        }
        groupIndex.setGroup(adminGroup);
        PermissionUtils.createDefaultRoles(permissionIndex);
        PermissionUtils.assignAdminPermissions(adminGroup, permissionIndex);
    }

    public static void createDefaultAdminToken(GlobalStorageSystem storageSystem) throws StorageException {
        EncryptedAccessKeyIndex encryptedAccessKeyIndex = (EncryptedAccessKeyIndex)storageSystem.openGlobalIndex(EncryptedAccessKeyIndex.class);
        byte[] password = StringUtils.stringToBytes((String)"admin");
        String hash = new HashedStoredPasswordAuthenticator().generateNewAuthenticator(password);
        AccessKey key = new AccessKey(hash);
        encryptedAccessKeyIndex.addAccessKey("admin", key);
    }

    public static void updateUserInIndex(UserIndex userIndex, User user, @Nullable String additionalDetailsField, IMessageBroker messageBroker) throws StorageException {
        User existingUser = userIndex.getUser(user.getUsername());
        if (existingUser != null) {
            user.setGroupIds(existingUser.getGroupIds());
            user.setAliases((Collection<String>)existingUser.getAliases());
            HashMap<String, String> details = existingUser.getAdditionalDetailsMap();
            if (additionalDetailsField != null) {
                details.remove(additionalDetailsField);
            }
            user.getAdditionalDetailsMap().putAll(details);
        }
        userIndex.setUser(user, messageBroker);
    }

    public static <T extends User> T sanitizeUser(T user) {
        if (user == null) {
            return null;
        }
        UserUtils.preventAuthLeakage(user);
        return user;
    }

    private static void preventAuthLeakage(User user) {
        user.setAuthenticator(AuthenticationManager.getInstance().sanitizeAuthenticator(user.getAuthenticator()));
    }

    public static void deleteUser(User user, IndexLayer indexLayer, IMessageBroker messageBroker) throws StorageException {
        AuditLogs.deleteUser(user.getUsername());
        UserGroupIndex userGroupIndex = indexLayer.openGlobalIndex(UserGroupIndex.class);
        UserIndex userIndex = indexLayer.openGlobalIndex(UserIndex.class);
        SessionIndex sessionIndex = indexLayer.openGlobalIndex(SessionIndex.class);
        UserSatisfactionStatusIndex userSatisfactionStatusIndex = indexLayer.openGlobalIndex(UserSatisfactionStatusIndex.class);
        EncryptedAccessKeyIndex accessKeyIndex = indexLayer.openGlobalIndex(EncryptedAccessKeyIndex.class);
        userIndex.runWithUserUpdateLock(user.getUsername(), () -> {
            UserGroupUtils.removeFromAllGroups(user, userGroupIndex, messageBroker);
            UserUtils.invalidateUserSession(user.getUsername(), sessionIndex, messageBroker);
            accessKeyIndex.removeAccessKey(user.getUsername());
            userIndex.removeUser(user.getUsername(), messageBroker);
            userSatisfactionStatusIndex.removeUserSatisfactionStatus(user.getUsername());
        });
    }

    public static void invalidateUserSession(String userName, SessionIndex sessionIndex, IMessageBroker messageBroker) throws StorageException {
        List<String> invalidatedTokens = sessionIndex.removeTokensForUsers(Collections.singletonList(userName));
        for (String invalidatedToken : invalidatedTokens) {
            messageBroker.sendMessage("invalidate-session-cache-token", invalidatedToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception, R> R wipeAfterUse(char[] password, FunctionWithException<byte[], R, E> passwordBytesConsumer) throws E {
        byte[] passwordBytes = SecurityUtils.asByteArray(password);
        if (password != null) {
            Arrays.fill(password, '\u0000');
        }
        try {
            Object object = passwordBytesConsumer.apply((Object)passwordBytes);
            return (R)object;
        }
        finally {
            if (passwordBytes != null) {
                Arrays.fill(passwordBytes, (byte)0);
            }
        }
    }

    private UserUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

