/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class TempFileFactory {
    private final CanonicalFile tmpBaseDir;
    private final AtomicInteger tempFileCounter = new AtomicInteger(0);

    public TempFileFactory(File tempDir) throws IOException {
        if (!tempDir.exists()) {
            throw new IOException("Temporary directory " + String.valueOf(tempDir) + " does not exist!");
        }
        if (!tempDir.isDirectory()) {
            throw new IOException("Temporary directory " + String.valueOf(tempDir) + " exists but is no directory!");
        }
        if (!tempDir.canWrite()) {
            throw new IOException("Temporary directory " + String.valueOf(tempDir) + " exists but is not writable!");
        }
        this.tmpBaseDir = this.createUniqueFile(tempDir, "cq_", "_tmp");
        FileSystemUtils.ensureDirectoryExists((File)this.tmpBaseDir);
    }

    public CanonicalFile getTempFile(String prefix, String suffix) {
        try {
            return this.createUniqueFile((File)this.tmpBaseDir, prefix, suffix);
        }
        catch (IOException e) {
            throw new AssertionError("Could not create temp file: " + e.getMessage(), e);
        }
    }

    private CanonicalFile createUniqueFile(File baseDir, String prefix, String suffix) throws IOException {
        File result;
        while ((result = new File(baseDir, prefix + this.tempFileCounter.getAndIncrement() + suffix)).exists()) {
        }
        return new CanonicalFile(result);
    }

    public CanonicalFile getTemporaryDirectory() {
        return this.tmpBaseDir;
    }
}

