/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import com.teamscale.core.index.CommitDescriptorIndex;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;

public final class UnresolvedCommitDescriptorUtils {
    public static UnresolvedCommitDescriptor parseCommit(String commitString) throws IllegalArgumentException {
        return UnresolvedCommitDescriptor.getInstance((String)commitString);
    }

    public static @NonNull CommitDescriptor resolve(UnresolvedCommitDescriptor unresolvedCommitDescriptor, IFactory<ProjectStorageSystem, StorageException> projectStorageSystemFactory) throws StorageException {
        String branchName = unresolvedCommitDescriptor.getBranchName();
        if (branchName == null) {
            branchName = UnresolvedCommitDescriptorUtils.getDefaultBranchName(projectStorageSystemFactory);
        }
        long timestamp = unresolvedCommitDescriptor.getTimestamp();
        CommitDescriptor commit = new CommitDescriptor(branchName, timestamp);
        int parentIndex = unresolvedCommitDescriptor.getParentIndex();
        if (parentIndex > 0) {
            CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)((ProjectStorageSystem)projectStorageSystemFactory.create()).openProjectIndex(CommitDescriptorIndex.class, null);
            for (int i = 0; i < Math.min(parentIndex, 1000); ++i) {
                commit = UnresolvedCommitDescriptorUtils.resolveParent(commit, commitDescriptorIndex);
            }
        }
        if (unresolvedCommitDescriptor.isIncludeExternalUploads()) {
            commit = new CommitDescriptor(commit.getBranchName(), commit.getTimestamp() + 500L);
        }
        return commit;
    }

    public static CommitDescriptor resolveCommitWithFallbackTimestamp(UnresolvedCommitDescriptor commit, long fallbackTimestamp, IFactory<ProjectStorageSystem, StorageException> projectStorageSystemFactory) throws StorageException {
        CommitDescriptor commitDescriptor = UnresolvedCommitDescriptorUtils.resolve(commit, projectStorageSystemFactory);
        if (commitDescriptor.getTimestamp() == Long.MAX_VALUE) {
            return new CommitDescriptor(commitDescriptor.getBranchName(), fallbackTimestamp);
        }
        return commitDescriptor;
    }

    public static @NonNull CommitDescriptor resolveParent(CommitDescriptor commit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        ParentedCommitDescriptor parentedCommit = commitDescriptorIndex.getCommit(commit);
        if (parentedCommit == null || parentedCommit.getParentCommits().isEmpty()) {
            return new CommitDescriptor(commit.getBranchName(), 1L);
        }
        return (CommitDescriptor)parentedCommit.getParentCommits().getFirst();
    }

    private static String getDefaultBranchName(IFactory<ProjectStorageSystem, StorageException> projectStorageSystemFactory) throws StorageException {
        return ((MetaIndex)((ProjectStorageSystem)projectStorageSystemFactory.create()).openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
    }

    public static CommitDescriptor parseAndResolveCommit(String commitString, IFactory<ProjectStorageSystem, StorageException> projectStorageSystemFactory) throws StorageException {
        return UnresolvedCommitDescriptorUtils.resolve(UnresolvedCommitDescriptorUtils.parseCommit(commitString), projectStorageSystemFactory);
    }

    private UnresolvedCommitDescriptorUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

