/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.collections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Spliterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.collections.DurableCollectionHelper;
import org.conqat.engine.persistence.index.collections.EDurableCollectionOperation;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.jspecify.annotations.NonNull;

public class DurableSet<T extends Serializable>
extends AbstractSet<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private HashSet<T> delegate = new HashSet();
    private final DurableCollectionHelper helper;

    DurableSet(IStore store, byte[] keyPrefix) throws StorageException {
        this.helper = new DurableCollectionHelper(store, keyPrefix){

            @Override
            protected int getCollectionSize() {
                return DurableSet.this.delegate.size();
            }

            @Override
            protected byte[] serializeFullCollection() throws StorageException {
                return StorageUtils.serialize(DurableSet.this.delegate);
            }

            @Override
            protected void replayOperation(EDurableCollectionOperation operation, byte[] parameter) throws StorageException {
                switch (operation) {
                    case SNAPSHOT: {
                        DurableSet.this.delegate = (HashSet)StorageUtils.deserialize(parameter);
                        break;
                    }
                    case REMOVE: {
                        DurableSet.this.delegate.remove(StorageUtils.deserialize(parameter));
                        break;
                    }
                    case CLEAR: {
                        DurableSet.this.delegate.clear();
                        break;
                    }
                    case ADD: {
                        DurableSet.this.delegate.add(StorageUtils.deserialize(parameter));
                        break;
                    }
                    default: {
                        throw new StorageException("Unsupported operation: " + String.valueOf((Object)operation));
                    }
                }
            }
        };
    }

    @Override
    public @NonNull Iterator<T> iterator() {
        final Iterator<T> delegateIterator = this.delegate.iterator();
        return new Iterator<T>(){
            private T lastReturned;

            @Override
            public boolean hasNext() {
                return delegateIterator.hasNext();
            }

            @Override
            public T next() {
                this.lastReturned = (Serializable)delegateIterator.next();
                return this.lastReturned;
            }

            @Override
            public void remove() {
                delegateIterator.remove();
                try {
                    DurableSet.this.helper.storeOperation(EDurableCollectionOperation.REMOVE, StorageUtils.serialize(this.lastReturned));
                }
                catch (StorageException e) {
                    LOGGER.error("Failed to persist collection change! Stored data might be inconsistent until next snapshot!", (Throwable)((Object)e));
                }
            }
        };
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean add(T e) {
        boolean added = this.delegate.add(e);
        if (added) {
            try {
                this.helper.storeOperation(EDurableCollectionOperation.ADD, StorageUtils.serialize(e));
            }
            catch (StorageException e1) {
                LOGGER.error("Failed to persist collection change! Stored data might be inconsistent until next snapshot!", (Throwable)((Object)e1));
            }
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.delegate.remove(o);
        if (removed) {
            try {
                this.helper.storeOperation(EDurableCollectionOperation.REMOVE, StorageUtils.serialize((Serializable)o));
            }
            catch (StorageException e) {
                LOGGER.error("Failed to persist collection change! Stored data might be inconsistent until next snapshot!", (Throwable)((Object)e));
            }
        }
        return removed;
    }

    @Override
    public void clear() {
        if (this.delegate.isEmpty()) {
            return;
        }
        this.delegate.clear();
        try {
            this.helper.storeOperation(EDurableCollectionOperation.CLEAR, null);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to persist collection change! Stored data might be inconsistent until next snapshot!", (Throwable)((Object)e));
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.delegate.spliterator();
    }
}

