/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.base;

import java.io.File;
import java.io.IOException;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public abstract class StorageSystemBase
implements IStorageSystem {
    private final int storageSystemId;

    protected StorageSystemBase(int storageSystemId) {
        this.storageSystemId = storageSystemId;
    }

    public static void ensureStorageDirectoryExists(File storageDirectory) throws StorageException {
        try {
            FileSystemUtils.ensureDirectoryExists((File)storageDirectory);
        }
        catch (IOException e) {
            throw new StorageException("Could not create store location: " + String.valueOf(storageDirectory), e);
        }
    }

    @Override
    public void removeStore(String name) throws StorageException {
        StorageUtils.clearStore(this, name);
    }

    @Override
    public int getStorageSystemId() {
        return this.storageSystemId;
    }
}

