/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ConditionalStatementSubtypes {
    private static final Map<ELanguage, Set<String>> CONDITIONAL_SUBTYPES = new EnumMap<ELanguage, Set<String>>(ELanguage.class);

    public static boolean supportsLanguageForBranchCoverage(ELanguage language) {
        if (language == ELanguage.JAVASCRIPT || language == ELanguage.PYTHON) {
            return false;
        }
        return CONDITIONAL_SUBTYPES.containsKey(language);
    }

    public static boolean isConditionalStatement(ShallowEntity entity) {
        if (entity.isEmpty() || entity.getType() != EShallowEntityType.STATEMENT) {
            return false;
        }
        ELanguage language = ((IToken)CollectionUtils.getAny((Iterable)entity.includedTokens())).getLanguage();
        return ConditionalStatementSubtypes.isSubtypeConditionalStatement(entity, language);
    }

    public static boolean isConditionalStatement(ShallowEntity entity, ELanguage language) {
        if (entity.isEmpty() || entity.getType() != EShallowEntityType.STATEMENT) {
            return false;
        }
        return ConditionalStatementSubtypes.isSubtypeConditionalStatement(entity, language);
    }

    private static boolean isSubtypeConditionalStatement(ShallowEntity entity, ELanguage language) {
        String subtype = entity.getSubtype();
        Set<String> subtypes = CONDITIONAL_SUBTYPES.get(language);
        if (!language.isCaseSensitive()) {
            subtype = subtype.toLowerCase();
        }
        return subtypes != null && subtypes.contains(subtype);
    }

    static {
        HashSet clikeConditionals = CollectionUtils.asHashSet((Object[])new String[]{"if", "else if", "while", "do", "for", "foreach"});
        CONDITIONAL_SUBTYPES.put(ELanguage.JAVA, clikeConditionals);
        CONDITIONAL_SUBTYPES.put(ELanguage.CPP, clikeConditionals);
        CONDITIONAL_SUBTYPES.put(ELanguage.CPP_MS_CLI, clikeConditionals);
        CONDITIONAL_SUBTYPES.put(ELanguage.C, clikeConditionals);
        CONDITIONAL_SUBTYPES.put(ELanguage.CS, clikeConditionals);
        CONDITIONAL_SUBTYPES.put(ELanguage.ADA, CollectionUtils.asHashSet((Object[])new String[]{"if", "elsif", "for", "while"}));
        CONDITIONAL_SUBTYPES.put(ELanguage.JAVASCRIPT, clikeConditionals);
        CONDITIONAL_SUBTYPES.put(ELanguage.PYTHON, CollectionUtils.asHashSet((Object[])new String[]{"if", "elif", "while"}));
    }
}

