/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal;

import com.microsoft.tfs.core.clients.build.IBuildController;
import com.microsoft.tfs.core.clients.build.IBuildControllerQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildControllerSpec;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinitionComparer;
import com.microsoft.tfs.core.clients.build.utils.BuildPath;
import com.microsoft.tfs.util.Check;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TeamBuildCache {
    public static final int CACHE_TIMEOUT_VALUE = 300000;
    private static final Map<String, TeamBuildCache> instances = new HashMap<String, TeamBuildCache>(3);
    private final IBuildServer buildServer;
    private final String teamProject;
    private IBuildDefinition[] buildDefinitions;
    private long buildDefinitionCacheTime;
    private final Object buildDefinitionLock = new Object();
    private IBuildController[] buildControllers;
    private long buildControllerCacheTime;
    private final Object buildControllerLock = new Object();
    private String[] buildQualities;
    private long buildQualitiesCacheTime;
    private final Object buildQualityLock = new Object();
    private final String cacheInstanceKey;

    private TeamBuildCache(String cacheInstanceKey, IBuildServer buildServer, String teamProject) {
        this.cacheInstanceKey = cacheInstanceKey;
        this.buildServer = buildServer;
        this.teamProject = teamProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBuildDefinition[] getBuildDefinitions(boolean forceRefresh) {
        Object object = this.buildDefinitionLock;
        synchronized (object) {
            if (forceRefresh || this.buildDefinitions == null || this.cacheExpired(this.buildDefinitionCacheTime)) {
                this.buildDefinitions = this.buildServer.queryBuildDefinitions(this.teamProject);
                Arrays.sort(this.buildDefinitions, new BuildDefinitionComparer(this.buildServer));
                this.buildDefinitionCacheTime = System.currentTimeMillis();
            }
        }
        return this.buildDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBuildController[] getBuildControllers(boolean forceRefresh) {
        IBuildDefinition[] v1Definitions = null;
        if ((forceRefresh || this.buildControllers == null || this.cacheExpired(this.buildControllerCacheTime)) && this.buildServer.getBuildServerVersion().isV1()) {
            v1Definitions = this.getBuildDefinitions(forceRefresh);
        }
        Object object = this.buildControllerLock;
        synchronized (object) {
            if (forceRefresh || this.buildControllers == null || this.cacheExpired(this.buildControllerCacheTime)) {
                if (this.buildServer.getBuildServerVersion().isV1()) {
                    this.buildControllers = this.getBuildControllersFromDefinitions(v1Definitions);
                } else if (this.buildServer.getBuildServerVersion().isV2()) {
                    IBuildControllerSpec controllerSpec = this.buildServer.createBuildControllerSpec();
                    controllerSpec.setName(BuildPath.combine(this.teamProject, "*"));
                    IBuildControllerQueryResult result = this.buildServer.queryBuildControllers(controllerSpec);
                    this.buildControllers = result.getControllers();
                    if (result.getFailures().length > 0) {
                        throw new RuntimeException(result.getFailures()[0].getMessage());
                    }
                } else {
                    this.buildControllers = this.buildServer.queryBuildControllers(true);
                }
                this.buildControllerCacheTime = System.currentTimeMillis();
            }
        }
        return this.buildControllers;
    }

    public void reloadBuildDefinitionsAndControllers() {
        if (this.buildServer.getBuildServerVersion().isV1()) {
            this.getBuildControllers(true);
        } else {
            this.getBuildDefinitions(true);
            this.getBuildControllers(true);
        }
    }

    private IBuildController[] getBuildControllersFromDefinitions(IBuildDefinition[] buildDefinitions) {
        HashMap<String, IBuildController> buildControllers = new HashMap<String, IBuildController>();
        for (int i = 0; i < buildDefinitions.length; ++i) {
            IBuildController buildController = buildDefinitions[i].getBuildController();
            if (buildController == null || buildController.getName() == null || buildController.getName().length() <= 0) continue;
            String name = buildController.getName() + "_" + buildDefinitions[i].getName();
            buildDefinitions[i].setBuildController(buildController);
            buildControllers.put(name, buildController);
        }
        Collection values = buildControllers.values();
        return values.toArray(new IBuildController[values.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBuildQualities(boolean forceRefresh) {
        Object object = this.buildQualityLock;
        synchronized (object) {
            if (forceRefresh || this.buildQualities == null || this.cacheExpired(this.buildQualitiesCacheTime)) {
                this.buildQualities = this.buildServer.getBuildQualities(this.teamProject);
                Arrays.sort(this.buildQualities, Collator.getInstance());
                this.buildQualitiesCacheTime = System.currentTimeMillis();
            }
        }
        return this.buildQualities;
    }

    private boolean cacheExpired(long cachedTime) {
        return System.currentTimeMillis() > cachedTime + 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TeamBuildCache refreshInstance(IBuildServer buildServer, String teamProjectName) {
        Check.notNull(buildServer, "buildServer");
        Check.notNullOrEmpty(teamProjectName, "teamProjectName");
        String key = buildServer.getConnection().getAuthorizedTFSUser().toString() + "@" + buildServer.getConnection().getInstanceID().getGUIDString() + "/" + teamProjectName;
        Map<String, TeamBuildCache> map = instances;
        synchronized (map) {
            TeamBuildCache instance = new TeamBuildCache(key, buildServer, teamProjectName);
            instances.put(key, instance);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TeamBuildCache getInstance(IBuildServer buildServer, String teamProjectName) {
        Check.notNull(buildServer, "buildServer");
        Check.notNullOrEmpty(teamProjectName, "teamProjectName");
        String key = buildServer.getConnection().getAuthorizedTFSUser().toString() + "@" + buildServer.getConnection().getInstanceID().getGUIDString() + "/" + teamProjectName;
        Map<String, TeamBuildCache> map = instances;
        synchronized (map) {
            TeamBuildCache instance = instances.get(key);
            if (instance == null) {
                instance = new TeamBuildCache(key, buildServer, teamProjectName);
                instances.put(key, instance);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Map<String, TeamBuildCache> map = instances;
        synchronized (map) {
            instances.clear();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheInstanceKey == null ? 0 : this.cacheInstanceKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeamBuildCache)) {
            return false;
        }
        TeamBuildCache other = (TeamBuildCache)obj;
        return !(this.cacheInstanceKey == null ? other.cacheInstanceKey != null : !this.cacheInstanceKey.equals(other.cacheInstanceKey));
    }
}

