/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.AdministrationWebService;
import com.microsoft.tfs.core.clients.build.BuildQueueWebService;
import com.microsoft.tfs.core.clients.build.BuildWebService;
import com.microsoft.tfs.core.clients.build.IBuildAgentQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildAgentSpec;
import com.microsoft.tfs.core.clients.build.IBuildControllerQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildControllerSpec;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionSpec;
import com.microsoft.tfs.core.clients.build.IBuildDeletionResult;
import com.microsoft.tfs.core.clients.build.IBuildDetail;
import com.microsoft.tfs.core.clients.build.IBuildDetailSpec;
import com.microsoft.tfs.core.clients.build.IBuildRequest;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IQueuedBuild;
import com.microsoft.tfs.core.clients.build.IQueuedBuildSpec;
import com.microsoft.tfs.core.clients.build.flags.DeleteOptions;
import com.microsoft.tfs.core.clients.build.flags.QueryDeletedOption;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions;
import com.microsoft.tfs.core.clients.build.flags.QueueOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgentQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgentQueryResult2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgentUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildControllerQueryResult2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildControllerUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinitionQueryResult2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDeletionResult2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueryResult2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueQueryResult2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueSpec;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueSpec2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHostQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHostQueryResult2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHostUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationChangeRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.ProcessTemplate;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.ProcessTemplate2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuild;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuild2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuildUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.soapextensions.DefinitionTriggerType;
import com.microsoft.tfs.core.clients.build.soapextensions.ProcessTemplateType;
import java.util.ArrayList;

public class Build2010Helper
extends TFS2010Helper {
    private final BuildServer buildServer;
    private final BuildWebService buildService;
    private final BuildQueueWebService buildQueueService;
    private final AdministrationWebService administrationService;

    public Build2010Helper(BuildServer buildServer) {
        this.buildServer = buildServer;
        this.buildService = new BuildWebService(buildServer.getConnection());
        this.buildQueueService = new BuildQueueWebService(buildServer.getConnection());
        this.administrationService = new AdministrationWebService(buildServer.getConnection());
    }

    public BuildQueueQueryResult queryQueuedBuildsById(int[] queuedBuildIds, QueryOptions options) {
        BuildQueueQueryResult2010 result = this.buildQueueService.queryBuildsById(queuedBuildIds, Build2010Helper.convert(options));
        return Build2010Helper.convert(this.buildServer, result);
    }

    public QueuedBuild[] queueBuilds(IBuildRequest[] requests, QueueOptions options) {
        QueuedBuild2010[] results = this.buildQueueService.queueBuilds(Build2010Helper.convert(requests), Build2010Helper.convert(options));
        ArrayList<QueuedBuild> newBuilds = new ArrayList<QueuedBuild>(results.length);
        for (int i = 0; i < results.length; ++i) {
            QueuedBuild newBuild = Build2010Helper.convert((IBuildServer)this.buildServer, results[i]);
            newBuild.setBuildController(requests[i].getBuildController());
            newBuild.setBuildDefinition(requests[i].getBuildDefinition());
            newBuilds.add(newBuild);
        }
        return newBuilds.toArray(new QueuedBuild[newBuilds.size()]);
    }

    public IQueuedBuild[] updateQueuedBuilds(QueuedBuildUpdateOptions[] updates) {
        QueuedBuild2010[] results = this.buildQueueService.updateBuilds(Build2010Helper.convert(updates));
        return Build2010Helper.convert((IBuildServer)this.buildServer, results);
    }

    public BuildDetail notifyBuildCompleted(String uri) {
        BuildDetail2010 results = this.buildService.notifyBuildCompleted(uri);
        return Build2010Helper.convert((IBuildServer)this.buildServer, results);
    }

    public BuildDetail[] updateBuilds(BuildUpdateOptions[] updateOptions) {
        BuildDetail2010[] results = this.buildService.updateBuilds(Build2010Helper.convert(updateOptions));
        return Build2010Helper.convert((IBuildServer)this.buildServer, results);
    }

    public BuildInformationNode[] updateBuildInformation(InformationChangeRequest[] requests) {
        BuildInformationNode2010[] results = this.buildService.updateBuildInformation(Build2010Helper.convert(requests));
        return Build2010Helper.convert(results);
    }

    public IBuildDefinition[] getAffectedBuildDefinitions(String[] serverItems, DefinitionTriggerType triggerType) {
        BuildDefinition2010[] results = this.buildService.getAffectedBuildDefinitions(serverItems, Build2010Helper.convert(triggerType));
        return Build2010Helper.convert((IBuildServer)this.buildServer, results);
    }

    public IBuildDetail[] queryBuildsByUri(String[] buildUris, String[] informationTypes, QueryOptions queryOptions, QueryDeletedOption queryDeletedOption) {
        BuildQueryResult2010 result = this.buildService.queryBuildsByUri(buildUris, informationTypes, Build2010Helper.convert(queryOptions), Build2010Helper.convert(queryDeletedOption));
        return this.convert((IBuildServer)this.buildServer, result).getBuilds();
    }

    public BuildQueryResult[] queryBuilds(IBuildDetailSpec[] specs) {
        BuildQueryResult2010[] results = this.buildService.queryBuilds(Build2010Helper.convert((IBuildServer)this.buildServer, specs));
        return this.convert((IBuildServer)this.buildServer, results);
    }

    public IBuildDeletionResult[] deleteBuilds(String[] uris, DeleteOptions options) {
        BuildDeletionResult2010[] results = this.buildService.deleteBuilds(uris, Build2010Helper.convert(options));
        return Build2010Helper.convert(results);
    }

    public void destroyBuilds(String[] buildUris) {
        this.buildService.destroyBuilds(buildUris);
    }

    public IBuildDefinitionQueryResult queryBuildDefinitionsByUri(String[] uris, QueryOptions options) {
        BuildDefinitionQueryResult2010 result = this.buildService.queryBuildDefinitionsByUri(uris, Build2010Helper.convert(options));
        return this.convert((IBuildServer)this.buildServer, result);
    }

    public IBuildDefinitionQueryResult[] queryBuildDefinitions(IBuildDefinitionSpec[] specs) {
        BuildDefinitionQueryResult2010[] results = this.buildService.queryBuildDefinitions(Build2010Helper.convert(specs));
        return this.convert((IBuildServer)this.buildServer, results);
    }

    public void deleteBuildDefinitions(String[] definitionUris) {
        this.buildService.deleteBuildDefinitions(definitionUris);
    }

    public IBuildDefinition[] addBuildDefinitions(BuildDefinition[] definitions) {
        BuildDefinition2010[] results = this.buildService.addBuildDefinitions(Build2010Helper.convert(definitions));
        return Build2010Helper.convert((IBuildServer)this.buildServer, results);
    }

    public IBuildDefinition[] updateBuildDefinitions(BuildDefinition[] definitions) {
        BuildDefinition2010[] results = this.buildService.updateBuildDefinitions(Build2010Helper.convert(definitions));
        return Build2010Helper.convert((IBuildServer)this.buildServer, results);
    }

    public void deleteBuildServiceHost(String serviceHostUri) {
        this.administrationService.deleteBuildServiceHost(serviceHostUri);
    }

    public BuildServiceHostQueryResult queryBuildServiceHosts(String computer) {
        BuildServiceHostQueryResult2010 result = this.administrationService.queryBuildServiceHosts(computer);
        return this.convert((IBuildServer)this.buildServer, result);
    }

    public BuildServiceHost addBuildServiceHost(BuildServiceHost serviceHost) {
        BuildServiceHost2010 result = this.administrationService.addBuildServiceHost(Build2010Helper.convert(serviceHost));
        return Build2010Helper.convert((IBuildServer)this.buildServer, result);
    }

    public void updateBuildServiceHost(BuildServiceHostUpdateOptions update) {
        this.administrationService.updateBuildServiceHost(Build2010Helper.convert(update));
    }

    public BuildServiceHostQueryResult testBuildServiceHostConnections(String uri) {
        BuildServiceHostQueryResult2010 result = this.administrationService.testBuildServiceHostConnections(uri);
        return this.convert((IBuildServer)this.buildServer, result);
    }

    public IBuildControllerQueryResult testBuildControllerConnection(String uri) {
        BuildControllerQueryResult2010 result = this.administrationService.testBuildControllerConnection(uri);
        return Build2010Helper.convert((IBuildServer)this.buildServer, result);
    }

    public BuildAgentQueryResult testBuildAgentConnection(String uri) {
        BuildAgentQueryResult2010 result = this.administrationService.testBuildAgentConnection(uri);
        return this.convert((IBuildServer)this.buildServer, result);
    }

    public BuildAgentQueryResult queryBuildAgentsByUri(String[] uris) {
        BuildAgentQueryResult2010 result = this.administrationService.queryBuildAgentsByUri(uris);
        return this.convert((IBuildServer)this.buildServer, result);
    }

    public IBuildAgentQueryResult[] queryBuildAgents(IBuildAgentSpec[] specs) {
        BuildAgentQueryResult2010[] results = this.administrationService.queryBuildAgents(Build2010Helper.convert(specs));
        return this.convert((IBuildServer)this.buildServer, results);
    }

    public void deleteBuildAgents(String[] agentUris) {
        this.administrationService.deleteBuildAgents(agentUris);
    }

    public BuildAgent[] addBuildAgents(BuildAgent[] agents) {
        BuildAgent2010[] results = this.administrationService.addBuildAgents(Build2010Helper.convert(agents));
        return Build2010Helper.convert(results);
    }

    public void updateBuildAgents(BuildAgentUpdateOptions[] updates) {
        this.administrationService.updateBuildAgents(Build2010Helper.convert(updates));
    }

    public BuildServiceHostQueryResult queryBuildServiceHostsByUri(String[] uris) {
        BuildServiceHostQueryResult2010 result = this.administrationService.queryBuildServiceHostsByUri(uris);
        return this.convert((IBuildServer)this.buildServer, result);
    }

    public IBuildControllerQueryResult queryBuildControllersByUri(String[] uris, boolean includeAgents) {
        BuildControllerQueryResult2010 result = this.administrationService.queryBuildControllersByUri(uris, includeAgents);
        return Build2010Helper.convert((IBuildServer)this.buildServer, result);
    }

    public IBuildControllerQueryResult[] queryBuildControllers(IBuildControllerSpec[] specs) {
        BuildControllerQueryResult2010[] results = this.administrationService.queryBuildControllers(Build2010Helper.convert(specs));
        return this.convert((IBuildServer)this.buildServer, results);
    }

    public void deleteBuildControllers(String[] controllerUris) {
        this.administrationService.deleteBuildControllers(controllerUris);
    }

    public BuildController[] addBuildControllers(BuildController[] controllers) {
        BuildController2010[] results = this.administrationService.addBuildControllers(Build2010Helper.convert(controllers));
        return Build2010Helper.convert((IBuildServer)this.buildServer, results);
    }

    public void updateBuildControllers(BuildControllerUpdateOptions[] updates) {
        this.administrationService.updateBuildControllers(Build2010Helper.convert(updates));
    }

    public BuildQueueQueryResult[] queryQueuedBuilds(IQueuedBuildSpec[] specs) {
        BuildQueueQueryResult2010[] results = this.buildQueueService.queryBuilds(Build2010Helper.convert(specs));
        return this.convert(this.buildServer, results);
    }

    public void stopBuilds(String[] uris) {
        this.buildService.stopBuilds(uris);
    }

    public void cancelBuilds(int[] ids) {
        this.buildQueueService.cancelBuilds(ids);
    }

    public void addBuildQualities(String teamProject, String[] qualities) {
        this.buildService.addBuildQualities(teamProject, qualities);
    }

    public void deleteBuildQualities(String teamProject, String[] qualities) {
        this.buildService.deleteBuildQualities(teamProject, qualities);
    }

    public String[] getBuildQualities(String teamProject) {
        return this.buildService.getBuildQualities(teamProject);
    }

    public ProcessTemplate[] queryProcessTemplates(String teamProject, ProcessTemplateType[] types) {
        ProcessTemplate2010[] results = this.buildService.queryProcessTemplates(teamProject, Build2010Helper.convert(types));
        return Build2010Helper.convert((IBuildServer)this.buildServer, results);
    }

    public void deleteProcessTemplates(int[] templateIds) {
        this.buildService.deleteProcessTemplates(templateIds);
    }

    public ProcessTemplate[] addProcessTemplates(ProcessTemplate[] templates) {
        ProcessTemplate2010[] results = this.buildService.addProcessTemplates(Build2010Helper.convert(templates));
        return Build2010Helper.convert((IBuildServer)this.buildServer, results);
    }

    public ProcessTemplate[] updateProcessTemplates(ProcessTemplate[] templates) {
        ProcessTemplate2010[] results = this.buildService.updateProcessTemplates(Build2010Helper.convert(templates));
        return Build2010Helper.convert((IBuildServer)this.buildServer, results);
    }

    public static BuildQueueSpec2010[] convert(IQueuedBuildSpec[] specs) {
        BuildQueueSpec2010[] newSpecs = new BuildQueueSpec2010[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            newSpecs[i] = new BuildQueueSpec2010((BuildQueueSpec)specs[i]);
        }
        return newSpecs;
    }
}

