/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.reporting;

import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.util.Hierarchical;
import com.microsoft.tfs.core.util.Labelable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ms.sql.reporting.reportingservices._CatalogItem;

public abstract class ReportNode
extends WebServiceObjectWrapper
implements Labelable,
Hierarchical {
    private final String projectName;
    private Object parent;
    private final List<ReportNode> children = new ArrayList<ReportNode>();

    protected ReportNode(String projectName, String path) {
        this(projectName, ReportNode.newCatalogItemWithOnlyPath(path));
    }

    protected ReportNode(String projectName, _CatalogItem item) {
        super(item);
        this.projectName = projectName;
    }

    private static _CatalogItem newCatalogItemWithOnlyPath(String path) {
        _CatalogItem item = new _CatalogItem();
        item.setPath(path);
        return item;
    }

    public _CatalogItem getWebServiceObject() {
        return (_CatalogItem)this.webServiceObject;
    }

    public String getCreatedBy() {
        return this.getWebServiceObject().getCreatedBy();
    }

    public Calendar getCreationDate() {
        return this.getWebServiceObject().getCreationDate();
    }

    public String getDescription() {
        return this.getWebServiceObject().getDescription();
    }

    public String getID() {
        return this.getWebServiceObject().getID();
    }

    public boolean isHidden() {
        return this.getWebServiceObject().isHidden();
    }

    @Override
    public String getLabel() {
        return this.getWebServiceObject().getName();
    }

    public String getModifiedBy() {
        return this.getWebServiceObject().getModifiedBy();
    }

    public Calendar getModifiedDate() {
        return this.getWebServiceObject().getModifiedDate();
    }

    public String getPath() {
        return this.getWebServiceObject().getPath();
    }

    public String getType() {
        return this.getWebServiceObject().getType().toString();
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void addChild(ReportNode child) {
        this.children.add(child);
    }

    public ReportNode[] getChildReportNodes() {
        return this.children.toArray(new ReportNode[this.children.size()]);
    }

    @Override
    public Object[] getChildren() {
        return this.children.toArray();
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

