/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.security;

import com.microsoft.tfs.core.clients.security.ActionDefinition;
import com.microsoft.tfs.core.clients.security.SecurityNamespaceStructure;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import ms.ws._ActionDefinition;
import ms.ws._SecurityNamespaceDescription;

public class SecurityNamespaceDescription
extends WebServiceObjectWrapper
implements Cloneable {
    public SecurityNamespaceDescription(_SecurityNamespaceDescription webServiceObject) {
        super(webServiceObject);
    }

    public SecurityNamespaceDescription(GUID namespaceId, String name, String displayName, String databaseCategory, char separatorValue, int elementLength, SecurityNamespaceStructure structure, int writePermission, int readPermission, ActionDefinition[] actions) {
        this(new _SecurityNamespaceDescription(namespaceId.getGUIDString(), name, displayName, separatorValue, elementLength, writePermission, readPermission, databaseCategory, structure.getValue(), null, actions != null ? (_ActionDefinition[])WrapperUtils.unwrap(_ActionDefinition.class, actions) : new _ActionDefinition[]{}));
    }

    public _SecurityNamespaceDescription getWebServiceObject() {
        return (_SecurityNamespaceDescription)this.webServiceObject;
    }

    public SecurityNamespaceStructure getNamespaceStructure() {
        return SecurityNamespaceStructure.fromInteger(this.getWebServiceObject().getStructure());
    }

    public String getDisplayName() {
        String s = this.getWebServiceObject().getDisplayName();
        if (s == null || s.length() == 0) {
            return this.getName();
        }
        return s;
    }

    public GUID getNamespaceId() {
        return new GUID(this.getWebServiceObject().getNamespaceId());
    }

    public String getName() {
        return this.getWebServiceObject().getName();
    }

    public char getSeparatorValue() {
        return (char)this.getWebServiceObject().getSeparator();
    }

    public int getElementLength() {
        return this.getWebServiceObject().getElementLength();
    }

    public int getWritePermission() {
        return this.getWebServiceObject().getWritePermission();
    }

    public int getReadPermission() {
        return this.getWebServiceObject().getReadPermission();
    }

    public String getDatabaseCategory() {
        return this.getWebServiceObject().getDatabaseCategory();
    }

    public ActionDefinition[] getActions() {
        return (ActionDefinition[])WrapperUtils.wrap(ActionDefinition.class, this.getWebServiceObject().getActions());
    }

    public int getBitmaskForAction(String actionName) {
        Check.notNull(actionName, "actionName");
        _ActionDefinition[] actions = this.getWebServiceObject().getActions();
        if (actions != null) {
            for (_ActionDefinition action : actions) {
                if (!actionName.equalsIgnoreCase(action.getName())) continue;
                return action.getBit();
            }
        }
        return 0;
    }

    public String getActionNameForBitmask(int bitmask) {
        _ActionDefinition[] actions;
        for (_ActionDefinition action : actions = this.getWebServiceObject().getActions()) {
            if (action.getBit() != bitmask) continue;
            return action.getName();
        }
        return "";
    }

    public String getActionDisplayNameForBitmask(int bitmask) {
        _ActionDefinition[] actions;
        for (_ActionDefinition action : actions = this.getWebServiceObject().getActions()) {
            if (action.getBit() != bitmask) continue;
            return action.getDisplayName();
        }
        return "";
    }

    public SecurityNamespaceDescription clone() {
        ActionDefinition[] actions = this.getActions();
        if (actions == null) {
            actions = new ActionDefinition[]{};
        }
        return new SecurityNamespaceDescription(this.getNamespaceId(), this.getName(), this.getDisplayName(), this.getDatabaseCategory(), this.getSeparatorValue(), this.getElementLength(), this.getNamespaceStructure(), this.getWritePermission(), this.getReadPermission(), actions);
    }
}

