/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetStatus;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionStatus;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.util.FileEncoding;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class AutomergeWritableConflictResolution
extends ConflictResolution {
    private final List<Conflict> conflicts = new ArrayList<Conflict>();

    public AutomergeWritableConflictResolution(ConflictDescription conflictDescription, String description, String helpText) {
        super(conflictDescription, description, helpText, ConflictResolutionOptions.NONE);
    }

    @Override
    public ConflictResolution newForConflictDescription(ConflictDescription conflictDescription) {
        return new AutomergeWritableConflictResolution(conflictDescription, this.getDescription(), this.getHelpText());
    }

    @Override
    public void setNewPath(String newPath) {
        throw new TECoreException(Messages.getString("AutomergeWritableConflictResolution.AutomergeWritableConflictResolutionCannotAcceptNewPath"));
    }

    @Override
    public void setEncoding(FileEncoding newEncoding) {
        throw new TECoreException(Messages.getString("AutomergeWritableConflictResolution.AutomergeWritableConflictResolutionCannotAcceptNewEncoding"));
    }

    @Override
    protected ConflictResolutionStatus work() throws Exception {
        Workspace workspace = this.getConflictDescription().getWorkspace();
        Conflict conflict = this.getConflictDescription().getConflict();
        String localPath = conflict.getTargetLocalItem() != null ? conflict.getTargetLocalItem() : conflict.getSourceLocalItem();
        ItemSpec itemSpec = new ItemSpec(localPath, RecursionType.NONE);
        ChangesetVersionSpec versionSpec = new ChangesetVersionSpec(conflict.getTheirVersion());
        conflict.setResolution(Resolution.DELETE_CONFLICT);
        workspace.resolveConflict(conflict);
        if (!conflict.isResolved()) {
            throw new Exception(Messages.getString("AutomergeWritableConflictResolution.CouldNotResolveWritableConflict"));
        }
        if (workspace.pendEdit(new ItemSpec[]{itemSpec}, LockLevel.UNCHANGED, null, GetOptions.NONE, PendChangesOptions.NONE) < 1) {
            throw new Exception(MessageFormat.format(Messages.getString("AutomergeWritableConflictResolution.CouldNotPendEditFormat"), LocalPath.getFileName(localPath)));
        }
        GetStatus getStatus = workspace.get(new GetRequest(itemSpec, versionSpec), GetOptions.NONE);
        if (getStatus == null || getStatus.isCanceled()) {
            throw new Exception(Messages.getString("AutomergeWritableConflictResolution.CouldNotUpdateLocalVersionForAutomerge"));
        }
        if (getStatus.getNumFailures() > 0) {
            throw new Exception(getStatus.getFailures()[0].getMessage());
        }
        if (getStatus.getNumConflicts() == 0) {
            return ConflictResolutionStatus.SUCCESS;
        }
        Conflict[] newConflicts = workspace.queryConflicts(new String[]{localPath}, false);
        boolean hasUnresolvedConflicts = false;
        for (int i = 0; i < newConflicts.length; ++i) {
            newConflicts[i].setResolution(Resolution.ACCEPT_MERGE);
            workspace.resolveConflict(newConflicts[i]);
            if (newConflicts[i].isResolved()) continue;
            this.conflicts.add(newConflicts[i]);
            hasUnresolvedConflicts = true;
        }
        if (hasUnresolvedConflicts) {
            return ConflictResolutionStatus.SUCCEEDED_WITH_CONFLICTS;
        }
        return ConflictResolutionStatus.SUCCESS;
    }

    @Override
    public Conflict[] getConflicts() {
        return this.conflicts.toArray(new Conflict[this.conflicts.size()]);
    }
}

