/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.path;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.LocalPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.PathTooLongException;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemValidationError;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.Wildcard;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.LocaleInvariantStringHelpers;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LocalPath {
    public static final char TFS_PREFERRED_LOCAL_PATH_SEPARATOR = '\\';
    public static final String GENERAL_LOCAL_PATH_SEPARATOR = "/";
    private static final char[] VERSION_CONTROL_SEPARATORS = new char[]{';'};
    private static Pattern EIGHT_DOT_THREE_CHECKER = Pattern.compile("[\\\\/]([^\\\\/]*~\\d+)(\\.[^.]{1,3})?([\\\\/]|$)");
    public static final Comparator<String> TOP_DOWN_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String path1, String path2) {
            return LocalPath.compareTopDown(path1, path2);
        }
    };
    public static final Comparator<String> BOTTOM_UP_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String path1, String path2) {
            return LocalPath.compareBottomUp(path1, path2);
        }
    };

    public static final String getCurrentWorkingDirectory() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            return new File(".").getAbsolutePath();
        }
    }

    public static final boolean equals(String path1, String path2) {
        return LocalPath.equals(path1, path2, false);
    }

    public static final boolean equals(String path1, String path2, boolean forceIgnoreCase) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if (forceIgnoreCase || FileHelpers.doesFileSystemIgnoreCase()) {
            return path1.equalsIgnoreCase(path2);
        }
        return path1.equals(path2);
    }

    public static final boolean startsWith(String path, String prefix) {
        if (path.equals(prefix)) {
            return true;
        }
        if (path == null || prefix == null) {
            return false;
        }
        if (FileHelpers.doesFileSystemIgnoreCase()) {
            return LocaleInvariantStringHelpers.caseInsensitiveStartsWith(path, prefix);
        }
        return path.startsWith(prefix);
    }

    public static final boolean endsWith(String path, String suffix) {
        if (path.equals(suffix)) {
            return true;
        }
        if (path == null || suffix == null) {
            return false;
        }
        if (FileHelpers.doesFileSystemIgnoreCase()) {
            return LocaleInvariantStringHelpers.caseInsensitiveEndsWith(path, suffix);
        }
        return path.endsWith(suffix);
    }

    public static final boolean lastPartEqualsCaseSensitive(String path1, String path2) {
        String parent2;
        String parent1 = LocalPath.getDirectory(path1);
        if (!LocalPath.equals(parent1, parent2 = LocalPath.getDirectory(path2))) {
            return false;
        }
        return LocalPath.getFileName(path1).equals(LocalPath.getFileName(path2));
    }

    public static final int hashCode(String localPath) {
        if (FileHelpers.doesFileSystemIgnoreCase()) {
            return LocaleInvariantStringHelpers.caseInsensitiveHashCode(localPath) ^ 0x12D591;
        }
        return localPath.hashCode() ^ 0x12D591;
    }

    public static boolean isDirectChild(String parentPath, String possibleChild) {
        Check.notNull(parentPath, "parentPath");
        Check.notNull(possibleChild, "possibleChild");
        return LocalPath.equals(parentPath, LocalPath.getParent(possibleChild));
    }

    public static final boolean isChild(String parentPath, String possibleChild) {
        Check.notNull(parentPath, "parentPath");
        Check.notNull(possibleChild, "possibleChild");
        if (FileHelpers.doesFileSystemIgnoreCase() && parentPath.equalsIgnoreCase(possibleChild) || parentPath.equals(possibleChild)) {
            return true;
        }
        File parent = new File(parentPath);
        File child = new File(possibleChild);
        for (File tmp = child.getParentFile(); tmp != null; tmp = tmp.getParentFile()) {
            if (!tmp.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isDirectoryEmpty(String localPath) {
        Check.notNull(localPath, "localPath");
        return new File(localPath).list().length == 0;
    }

    public static final String tfsToNative(String localPath) {
        if (localPath == null) {
            return null;
        }
        Check.notEmpty(localPath, "localPath");
        if (Platform.isCurrentPlatform(Platform.GENERIC_UNIX) && localPath.startsWith("U:")) {
            localPath = localPath.substring(2).replace('\\', File.separatorChar);
        }
        return localPath;
    }

    public static final String nativeToTFS(String localPath) {
        if (localPath == null) {
            return null;
        }
        Check.notEmpty(localPath, "localPath");
        if (Platform.isCurrentPlatform(Platform.GENERIC_UNIX) && !localPath.startsWith("U:")) {
            localPath = "U:" + localPath.replace(File.separatorChar, '\\');
        }
        return localPath;
    }

    public static int getFolderDepth(String localPath) {
        return LocalPath.getFolderDepth(localPath, Platform.getCurrentPlatform());
    }

    public static int getFolderDepth(String localPath, Platform platform) {
        String separator;
        Check.notNullOrEmpty(localPath, "localPath");
        Check.notNull(platform, "forPlatform");
        boolean isWindows = platform.contains(Platform.WINDOWS);
        boolean isUnix = platform.contains(Platform.GENERIC_UNIX);
        if (isWindows) {
            separator = "\\";
            if (localPath.equals(separator)) {
                return 0;
            }
            if (localPath.length() == 2 && localPath.charAt(1) == ':') {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("LocalPath.DriveRootPathNotAbsoluteFormat"), localPath, separator));
            }
        } else if (isUnix) {
            separator = GENERAL_LOCAL_PATH_SEPARATOR;
            if (localPath.equals(separator)) {
                return 0;
            }
            if (localPath.charAt(0) != separator.charAt(0)) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("LocalPath.PathNotAbsoluteMustStartWithSeparatorFormat"), localPath, separator));
            }
        } else {
            throw new RuntimeException(MessageFormat.format(Messages.getString("LocalPath.UnsupportedPlatformFormat"), platform.toString()));
        }
        String[] segments = localPath.split(Pattern.quote(separator));
        if (isWindows) {
            if (localPath.startsWith("\\\\")) {
                if (segments.length < 4 || segments[2].length() == 0 || segments[3].length() == 0) {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.getString("LocalPath.UNCPathIncompleteFormat"), localPath));
                }
                return segments.length - 4;
            }
            if (localPath.startsWith(separator) || localPath.length() > 2 && localPath.charAt(1) == ':' && localPath.charAt(2) == separator.charAt(0)) {
                return segments.length - 1;
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("LocalPath.PathNotAbsoluteFormat"), localPath));
        }
        if (isUnix) {
            return segments.length - 1;
        }
        throw new RuntimeException(MessageFormat.format(Messages.getString("LocalPath.UnsupportedPlatformFormat"), platform.toString()));
    }

    public static final String combine(String parent, String relative) {
        Check.notNull(parent, "parent");
        Check.notNull(relative, "relative");
        File relativeFile = new File(relative);
        if (relativeFile.isAbsolute()) {
            return relative;
        }
        return new File(parent, relative).getAbsolutePath();
    }

    public static String[] getHierarchy(String path) {
        ArrayList<String> hierarchyList = new ArrayList<String>();
        for (File subfile = new File(path).getAbsoluteFile(); subfile != null; subfile = subfile.getParentFile()) {
            hierarchyList.add(subfile.getPath());
        }
        int len = hierarchyList.size();
        String[] hierarchy = new String[len];
        for (int i = 0; i < len; ++i) {
            hierarchy[i] = (String)hierarchyList.get(len - i - 1);
        }
        return hierarchy;
    }

    public static String[] getHierarchy(String fromPath, String toPath) {
        if (StringUtil.isNullOrEmpty(toPath)) {
            return LocalPath.getHierarchy(fromPath);
        }
        if (StringUtil.isNullOrEmpty(fromPath)) {
            return LocalPath.getHierarchy(toPath);
        }
        ArrayList<String> hierarchyList = new ArrayList<String>();
        File toFile = new File(toPath);
        for (File subfile = new File(fromPath).getAbsoluteFile(); subfile != null; subfile = subfile.getParentFile()) {
            hierarchyList.add(subfile.getPath());
            if (subfile.equals(toFile)) break;
        }
        int len = hierarchyList.size();
        String[] hierarchy = new String[len];
        for (int i = 0; i < len; ++i) {
            hierarchy[i] = (String)hierarchyList.get(len - i - 1);
        }
        return hierarchy;
    }

    public static String getParent(String path) {
        Check.notNull(path, "path");
        return new File(path).getParent();
    }

    public static String getDirectory(String path) {
        Check.notNull(path, "path");
        File f = new File(path);
        if (f.isDirectory()) {
            return f.getPath();
        }
        return f.getParent();
    }

    public static String getFileName(String localPath) {
        Check.notNull(localPath, "localPath");
        int index = localPath.lastIndexOf(File.separator);
        if (index == -1) {
            return localPath;
        }
        if (index + 1 < localPath.length()) {
            return localPath.substring(index + 1);
        }
        return "";
    }

    public static String getFileExtension(String localPath) {
        Check.notNull(localPath, "localPath");
        String localFilePart = LocalPath.getFileName(localPath);
        int index = localFilePart.lastIndexOf(46);
        if (index == -1 || localFilePart.length() <= index + 1) {
            return "";
        }
        return localFilePart.substring(index);
    }

    public static final String getLastComponent(String path) {
        Check.notNull(path, "path");
        return new File(path).getName();
    }

    public static final int compareTopDown(String pathA, String pathB) {
        if (FileHelpers.doesFileSystemIgnoreCase()) {
            return pathA.compareToIgnoreCase(pathB);
        }
        return pathA.compareTo(pathB);
    }

    public static final int compareBottomUp(String pathA, String pathB) {
        return 0 - LocalPath.compareTopDown(pathA, pathB);
    }

    public static final String canonicalize(String path) {
        File canonicalFile;
        if (path == null) {
            return null;
        }
        String expandedPath = LocalPath.expandTildeToHome(path);
        File child = new File(expandedPath).getAbsoluteFile();
        File parent = child.getParentFile();
        if (parent == null) {
            return child.getPath();
        }
        String name = child.getName();
        try {
            canonicalFile = name.equals(".") || name.equals("..") ? child.getCanonicalFile() : new File(parent.getCanonicalFile(), name);
        }
        catch (IOException e) {
            canonicalFile = child;
        }
        String canonicalPath = canonicalFile.getPath();
        if (canonicalPath.length() > 259) {
            throw new PathTooLongException(MessageFormat.format(Messages.getString("LocalPath.InvalidPathTooLongCanonicalizeFormat"), Integer.toString(259), canonicalPath));
        }
        return canonicalPath;
    }

    public static boolean isWildcard(String localPath) {
        Check.notNull(localPath, "localPath");
        int largestIndex = localPath.lastIndexOf(File.separator);
        if (largestIndex == localPath.length() - 1) {
            return false;
        }
        return Wildcard.isWildcard(localPath.substring(largestIndex + 1));
    }

    public static final boolean matchesWildcard(String firstItemPath, String secondItemFolderPath, String secondItemWildcardPattern, boolean recursive) {
        Check.notNull(firstItemPath, "firstItemPath");
        firstItemPath = LocalPath.canonicalize(firstItemPath);
        secondItemFolderPath = LocalPath.canonicalize(secondItemFolderPath);
        String firstItemFolder = null;
        String firstItemName = null;
        if (secondItemWildcardPattern == null || secondItemWildcardPattern.length() == 0) {
            firstItemFolder = firstItemPath;
        } else {
            firstItemFolder = LocalPath.getDirectory(firstItemPath);
            if (!LocalPath.equals(firstItemFolder, firstItemPath)) {
                firstItemName = LocalPath.getLastComponent(firstItemPath);
            }
        }
        if (secondItemFolderPath != null && (recursive ? !LocalPath.isChild(secondItemFolderPath, firstItemFolder) : !LocalPath.equals(firstItemFolder, secondItemFolderPath))) {
            return false;
        }
        if (firstItemName == null) {
            return true;
        }
        return ItemPath.matchesWildcardFile(firstItemName, 0, secondItemWildcardPattern, 0);
    }

    public static String makeRelative(String localPath, String relativeTo) {
        Check.notNull(localPath, "localPath");
        Check.notNull(relativeTo, "relativeTo");
        if (localPath.regionMatches(true, 0, relativeTo, 0, relativeTo.length())) {
            if (localPath.length() == relativeTo.length()) {
                return "";
            }
            if (relativeTo.length() > 0 && relativeTo.charAt(relativeTo.length() - 1) == File.separatorChar) {
                return localPath.substring(relativeTo.length());
            }
            if (localPath.charAt(relativeTo.length()) == File.separatorChar) {
                return localPath.substring(relativeTo.length() + 1);
            }
        }
        return localPath;
    }

    public static String makeServer(String localPath, String relativeToLocalPath, String serverRoot) {
        Check.notNull(localPath, "localPath");
        Check.notNull(relativeToLocalPath, "relativeToLocalPath");
        Check.notNull(serverRoot, "serverRoot");
        String relativePart = LocalPath.makeRelative(localPath, relativeToLocalPath);
        StringBuilder relativeBuffer = new StringBuilder(relativePart);
        for (int k = 0; k < relativeBuffer.length(); ++k) {
            if (relativeBuffer.charAt(k) != File.separatorChar) continue;
            relativeBuffer.setCharAt(k, '/');
        }
        if (relativeBuffer.length() > 0 && relativeBuffer.charAt(0) == '/') {
            relativeBuffer.deleteCharAt(0);
        }
        return ServerPath.canonicalize(serverRoot + '/' + relativeBuffer.toString());
    }

    public static String removeTrailingSeparators(String path) {
        int index;
        Check.notNull(path, "path");
        int length = path.length();
        for (index = path.length() - 1; index > 0 && path.charAt(index) == File.separatorChar; --index) {
        }
        return index < length - 1 ? path.substring(0, index + 1) : path;
    }

    public static String addTrailingSeparator(String path) {
        if (path == null) {
            return null;
        }
        return LocalPath.removeTrailingSeparators(path) + File.separatorChar;
    }

    protected static String expandTildeToHome(String pathString) {
        Check.notNull(pathString, "pathString");
        if (!Platform.isCurrentPlatform(Platform.GENERIC_UNIX)) {
            return pathString;
        }
        if ((pathString = StringUtil.trimBegin(pathString)).length() == 0) {
            return pathString;
        }
        if (pathString.charAt(0) == '~') {
            String replacement;
            int sepIndex = pathString.indexOf(File.separatorChar);
            if (pathString.length() == 1 || sepIndex == 1) {
                replacement = LocalPath.removeTrailingSeparators(System.getProperty("user.home"));
            } else {
                String homeDirectory = PlatformMiscUtils.getInstance().getHomeDirectory(pathString.substring(1, sepIndex != -1 ? sepIndex : pathString.length()));
                if (homeDirectory == null) {
                    return pathString;
                }
                replacement = LocalPath.removeTrailingSeparators(homeDirectory);
            }
            if (sepIndex == -1) {
                return replacement;
            }
            return replacement + pathString.substring(sepIndex);
        }
        return pathString;
    }

    public static ItemValidationError checkLocalItem(String item, String parameterName, boolean allowNull, boolean allowWildcards, boolean allow8Dot3Paths, boolean checkReservedCharacters) {
        if (item == null || item.length() == 0) {
            if (!allowNull) {
                throw new NullPointerException(parameterName);
            }
        } else {
            AtomicReference<Character> c;
            if (ServerPath.isServerPath(item)) {
                return ItemValidationError.LOCAL_ITEM_REQUIRED;
            }
            if (!allowWildcards && ItemPath.isWildcard(item)) {
                return ItemValidationError.WILDCARD_NOT_ALLOWED;
            }
            if (item.length() > 259) {
                throw new PathTooLongException(MessageFormat.format(Messages.getString("LocalPath.InvalidPathTooLongCheckItemFormat"), item, Integer.toString(259)));
            }
            if (!LocalPath.isPathRooted(item)) {
                throw new LocalPathFormatException(MessageFormat.format(Messages.getString("LocalPath.InvalidPathFormat"), item));
            }
            if (item.startsWith("\\") && !item.startsWith("\\\\")) {
                throw new LocalPathFormatException(MessageFormat.format(Messages.getString("LocalPath.InvalidPathFormat"), item));
            }
            if (!allow8Dot3Paths) {
                LocalPath.check8Dot3Aliases(item);
            }
            if (checkReservedCharacters && LocalPath.hasVersionControlReservedCharacter(item, c = new AtomicReference<Character>())) {
                throw new LocalPathFormatException(MessageFormat.format(Messages.getString("LocalPath.InvalidPathInvalidCharFormat"), item, Character.valueOf(c.get().charValue())));
            }
        }
        return ItemValidationError.NONE;
    }

    public static boolean hasVersionControlReservedCharacter(String path, AtomicReference<Character> c) {
        for (int i = 0; i < VERSION_CONTROL_SEPARATORS.length; ++i) {
            if (path.indexOf(VERSION_CONTROL_SEPARATORS[i]) == -1) continue;
            if (c != null) {
                c.set(Character.valueOf(VERSION_CONTROL_SEPARATORS[i]));
            }
            return true;
        }
        return false;
    }

    public static void check8Dot3Aliases(String item) {
        String baseNameGroup;
        Matcher matcher = EIGHT_DOT_THREE_CHECKER.matcher(item);
        if (matcher.find() && (baseNameGroup = matcher.group(1)) != null && baseNameGroup.length() <= 8) {
            throw new LocalPathFormatException(MessageFormat.format(Messages.getString("LocalPath.Invalid8Dot3PathFormat"), item));
        }
    }

    public static boolean isPathRooted(String path) {
        int length;
        return path != null && ((length = path.length()) >= 1 && (path.charAt(0) == '\\' || path.charAt(0) == '/') || length >= 2 && path.charAt(1) == ':');
    }

    public static String getPathRoot(String path) {
        return LocalPath.getPathRoot(path, Platform.getCurrentPlatform());
    }

    protected static String getPathRoot(String path, Platform platform) {
        if (path == null) {
            return null;
        }
        return path.substring(0, LocalPath.getRootLength(path, platform));
    }

    protected static int getRootLength(String path) {
        return LocalPath.getRootLength(path, Platform.getCurrentPlatform());
    }

    protected static int getRootLength(String path, Platform platform) {
        Check.notNull(path, "path");
        Check.notNull(platform, "platform");
        if (!FileHelpers.isValidNTFSPath(path, false)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("LocalPath.PathContainsInvalidNTFSCharactersFormat"), path));
        }
        int i = 0;
        int length = path.length();
        if (platform.contains(Platform.WINDOWS)) {
            if (length >= 1 && (path.charAt(0) == '\\' || path.charAt(0) == '/')) {
                i = 1;
                if (length >= 2 && (path.charAt(1) == '\\' || path.charAt(1) == '/')) {
                    int n = 2;
                    for (i = 2; i < length && (path.charAt(i) != '\\' && path.charAt(i) != '/' || --n > 0); ++i) {
                    }
                }
            } else if (length >= 2 && path.charAt(1) == ':') {
                i = 2;
                if (length >= 3 && (path.charAt(2) == '\\' || path.charAt(2) == '/')) {
                    ++i;
                }
            }
            return i;
        }
        if (length >= 1 && path.charAt(0) == '/') {
            i = 1;
        }
        return i;
    }

    public static void checkForIllegalDollarInPath(String path) {
        ItemPath.checkForIllegalDollarInPath(path);
    }

    public static String getCommonPathPrefix(String path1, String path2) {
        boolean path2EndsOnPathPart;
        int commonLength;
        Check.notNullOrEmpty(path1, "path1");
        Check.notNullOrEmpty(path2, "path2");
        boolean atLeastOneUncPath = Platform.isCurrentPlatform(Platform.WINDOWS) && path1.startsWith("\\\\");
        int lastSeparatorIndex = 0;
        int separatorCount = 0;
        for (commonLength = 0; commonLength < path1.length() && commonLength < path2.length() && Character.toUpperCase(path1.charAt(commonLength)) == Character.toUpperCase(path2.charAt(commonLength)); ++commonLength) {
            if (path1.charAt(commonLength) != File.separatorChar) continue;
            lastSeparatorIndex = commonLength;
            ++separatorCount;
        }
        if (0 == commonLength || atLeastOneUncPath && separatorCount < 3) {
            return null;
        }
        if (Platform.isCurrentPlatform(Platform.GENERIC_UNIX) && commonLength == 1) {
            Check.isTrue(path1.charAt(0) == File.separatorChar, "Path not canonicalized (must start with / on Unix)");
            return File.separator;
        }
        boolean path1EndsOnPathPart = commonLength == path1.length() || path1.charAt(commonLength) == File.separatorChar;
        boolean bl = path2EndsOnPathPart = commonLength == path2.length() || path2.charAt(commonLength) == File.separatorChar;
        if (!path1EndsOnPathPart || !path2EndsOnPathPart) {
            commonLength = lastSeparatorIndex;
            --separatorCount;
        }
        if (0 == commonLength || atLeastOneUncPath && separatorCount < 3) {
            return null;
        }
        String toReturn = path1.substring(0, commonLength);
        if (Platform.isCurrentPlatform(Platform.WINDOWS) && 2 == toReturn.length() && toReturn.charAt(1) == ':') {
            toReturn = toReturn + File.separator;
        }
        return toReturn;
    }

    public static boolean exists(String filePath) {
        if (StringUtil.isNullOrEmpty(filePath)) {
            return false;
        }
        return new File(filePath).exists();
    }
}

