/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.webservices;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.clients.webservices.FilteredIdentitiesList;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService2;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityHelper;
import com.microsoft.tfs.core.clients.webservices.IdentityManagementException;
import com.microsoft.tfs.core.clients.webservices.IdentityManagementService;
import com.microsoft.tfs.core.clients.webservices.IdentityPropertyScope;
import com.microsoft.tfs.core.clients.webservices.IdentitySearchFactor;
import com.microsoft.tfs.core.clients.webservices.MembershipQuery;
import com.microsoft.tfs.core.clients.webservices.ReadIdentityOptions;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.microsoft.tfs.core.clients.webservices.internal.TeamFoundationSupportedFeatures;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.Set;
import ms.ws._IdentityDescriptor;
import ms.ws._IdentityManagementWebService2Soap;
import ms.ws._PropertyValue;
import ms.ws._TeamFoundationIdentity;

public class IdentityManagementService2
extends IdentityManagementService
implements IIdentityManagementService2 {
    private final _IdentityManagementWebService2Soap proxy2;

    public IdentityManagementService2(TFSConnection connection) {
        super(connection);
        this.proxy2 = (_IdentityManagementWebService2Soap)connection.getWebService(_IdentityManagementWebService2Soap.class);
    }

    public boolean isSupported() {
        return this.proxy2 != null;
    }

    @Override
    public TeamFoundationIdentity[] getMostRecentlyUsedUsers() {
        TeamFoundationIdentity[] identities = (TeamFoundationIdentity[])WrapperUtils.wrap(TeamFoundationIdentity.class, this.proxy2.getMostRecentlyUsedUsers(TeamFoundationSupportedFeatures.ALL.getValue()));
        return identities;
    }

    @Override
    public void addRecentUser(TeamFoundationIdentity identity) {
        this.proxy2.addRecentUser(identity.getTeamFoundationID().getGUIDString());
    }

    @Override
    public FilteredIdentitiesList readFilteredIdentities(String expression, int suggestedPageSize, String lastSearchResult, boolean lookForward, int queryMembership) {
        FilteredIdentitiesList list = FilteredIdentitiesList.fromWebServiceObject(this.proxy2.readFilteredIdentities(expression, suggestedPageSize, lastSearchResult, lookForward, queryMembership, TeamFoundationSupportedFeatures.ALL.getValue()));
        return list;
    }

    @Override
    public TeamFoundationIdentity readIdentity(String generalSearchValue) {
        return this.readIdentity(IdentitySearchFactor.GENERAL, generalSearchValue, MembershipQuery.NONE, ReadIdentityOptions.NONE);
    }

    @Override
    public TeamFoundationIdentity[] listApplicationGroups(String scopeId, ReadIdentityOptions readOptions, String[] propertyNameFilters, IdentityPropertyScope propertyScope) {
        TeamFoundationIdentity[] groups = (TeamFoundationIdentity[])WrapperUtils.wrap(TeamFoundationIdentity.class, this.proxy2.listApplicationGroups(scopeId, readOptions.toIntFlags(), TeamFoundationSupportedFeatures.ALL.getValue(), propertyNameFilters, propertyScope.getValue()));
        return groups;
    }

    @Override
    public void setCustomDisplayName(String customDisplayName) {
        Check.notNullOrEmpty(customDisplayName, "customDisplayName");
        this.proxy2.setCustomDisplayName(customDisplayName);
    }

    @Override
    public void clearCustomDisplayName() {
        this.proxy2.setCustomDisplayName(null);
    }

    @Override
    public TeamFoundationIdentity[] readIdentities(IdentityDescriptor[] descriptors, MembershipQuery queryMembership, ReadIdentityOptions readOptions, String[] propertyNameFilters, IdentityPropertyScope propertyScope) {
        Check.notNull(descriptors, "descriptors");
        for (IdentityDescriptor descriptor : descriptors) {
            IdentityHelper.checkDescriptor(descriptor, "descriptors element");
        }
        TeamFoundationIdentity[] identities = (TeamFoundationIdentity[])WrapperUtils.wrap(TeamFoundationIdentity.class, this.proxy2.readIdentitiesByDescriptor((_IdentityDescriptor[])WrapperUtils.unwrap(_IdentityDescriptor.class, descriptors), queryMembership.getValue(), readOptions.toIntFlags(), TeamFoundationSupportedFeatures.ALL.getValue(), propertyNameFilters, propertyScope.getValue()));
        return identities;
    }

    @Override
    public TeamFoundationIdentity readIdentity(IdentityDescriptor descriptor, MembershipQuery queryMembership, ReadIdentityOptions readOptions, String[] propertyNameFilters, IdentityPropertyScope propertyScope) {
        return this.readIdentities(new IdentityDescriptor[]{descriptor}, queryMembership, readOptions, propertyNameFilters, propertyScope)[0];
    }

    @Override
    public TeamFoundationIdentity[] readIdentities(GUID[] teamFoundationIds, MembershipQuery queryMembership, ReadIdentityOptions readOptions, String[] propertyNameFilters, IdentityPropertyScope propertyScope) {
        Check.notNull(teamFoundationIds, "teamFoundationIds");
        String[] idStrings = new String[teamFoundationIds.length];
        for (int i = 0; i < teamFoundationIds.length; ++i) {
            Check.notNull(teamFoundationIds[i], "teamFoundationIds[i]");
            idStrings[i] = teamFoundationIds[i].getGUIDString();
        }
        TeamFoundationIdentity[] identities = (TeamFoundationIdentity[])WrapperUtils.wrap(TeamFoundationIdentity.class, this.proxy2.readIdentitiesById(idStrings, queryMembership.getValue(), TeamFoundationSupportedFeatures.ALL.getValue(), readOptions.toIntFlags(), propertyNameFilters, propertyScope.getValue()));
        return identities;
    }

    @Override
    public TeamFoundationIdentity[][] readIdentities(IdentitySearchFactor searchFactor, String[] searchFactorValues, MembershipQuery queryMembership, ReadIdentityOptions readOptions, String[] propertyNameFilters, IdentityPropertyScope propertyScope) {
        Check.notNull(searchFactorValues, "searchFactorValues");
        for (String factorValue : searchFactorValues) {
            Check.notNullOrEmpty(factorValue, "factorValue");
        }
        _TeamFoundationIdentity[][] wso = this.proxy2.readIdentities(searchFactor.getValue(), searchFactorValues, queryMembership.getValue(), readOptions.toIntFlags(), TeamFoundationSupportedFeatures.ALL.getValue(), propertyNameFilters, IdentityPropertyScope.NONE.getValue());
        TeamFoundationIdentity[][] results = new TeamFoundationIdentity[wso.length][];
        for (int i = 0; i < results.length; ++i) {
            results[i] = (TeamFoundationIdentity[])WrapperUtils.wrap(TeamFoundationIdentity.class, wso[i]);
        }
        return results;
    }

    @Override
    public TeamFoundationIdentity readIdentity(IdentitySearchFactor searchFactor, String searchFactorValue, MembershipQuery queryMembership, ReadIdentityOptions readOptions, String[] propertyNameFilters, IdentityPropertyScope propertyScope) {
        TeamFoundationIdentity[] results = this.readIdentities(searchFactor, new String[]{searchFactorValue}, queryMembership, readOptions, propertyNameFilters, propertyScope)[0];
        int resultCount = results.length;
        if (resultCount > 1) {
            int activeMatches = 0;
            TeamFoundationIdentity match = null;
            for (TeamFoundationIdentity result : results) {
                if (!result.isActive()) continue;
                match = result;
                ++activeMatches;
            }
            if (activeMatches != 1) {
                throw new IdentityManagementException(MessageFormat.format(Messages.getString("IdentityManagementService.MultipleIdentitiesFoundFormat"), searchFactorValue));
            }
            return match;
        }
        if (resultCount == 1) {
            return results[0];
        }
        return null;
    }

    @Override
    public void updateExtendedProperties(TeamFoundationIdentity identity) {
        Set<String> modifiedPropertiesLog = identity.getModifiedPropertiesLog(IdentityPropertyScope.GLOBAL);
        Set<String> modifiedLocalPropertiesLog = identity.getModifiedPropertiesLog(IdentityPropertyScope.LOCAL);
        if (modifiedPropertiesLog != null && modifiedPropertiesLog.size() > 0 || modifiedLocalPropertiesLog != null && modifiedLocalPropertiesLog.size() > 0) {
            _PropertyValue[] modifiedProperties = this.buildModifiedProperties(IdentityPropertyScope.GLOBAL, identity, modifiedPropertiesLog);
            _PropertyValue[] modifiedLocalProperties = this.buildModifiedProperties(IdentityPropertyScope.LOCAL, identity, modifiedLocalPropertiesLog);
            this.proxy2.updateIdentityExtendedProperties(identity.getDescriptor().getWebServiceObject(), modifiedProperties, modifiedLocalProperties);
            identity.resetModifiedProperties();
        }
    }

    private _PropertyValue[] buildModifiedProperties(IdentityPropertyScope propertyScope, TeamFoundationIdentity identity, Set<String> modifiedPropertiesLog) {
        _PropertyValue[] modifiedProperties = new _PropertyValue[modifiedPropertiesLog != null ? modifiedPropertiesLog.size() : 0];
        if (modifiedPropertiesLog != null) {
            int i = 0;
            for (String propertyName : modifiedPropertiesLog) {
                modifiedProperties[i++] = new _PropertyValue(propertyName, identity.getProperty(propertyScope, propertyName));
            }
        }
        return modifiedProperties;
    }
}

