/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query.qe;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinitionCollection;
import com.microsoft.tfs.core.clients.workitem.fields.FieldType;
import com.microsoft.tfs.core.clients.workitem.internal.query.qe.QEQueryRowCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.qe.WIQLTranslator;
import com.microsoft.tfs.core.clients.workitem.internal.query.qe.WIQLTranslatorFieldDefinitionCollectionAdatper;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryDefinitionUtil;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DateTime;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.WIQLAdapter;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQuery;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryGrouping;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryModifiedListener;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryRow;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryRowCollection;
import com.microsoft.tfs.core.clients.workitem.query.qe.WIQLOperators;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.LinkQueryMode;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryType;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.listeners.ListenerList;
import com.microsoft.tfs.util.listeners.StandardListenerList;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

public class QEQueryImpl
implements QEQuery {
    private final WorkItemClient workItemClient;
    private QueryType queryType;
    private LinkQueryMode linkQueryMode;
    private final QEQueryRowCollectionImpl sourceRows;
    private final QEQueryRowCollectionImpl targetRows;
    private boolean useSelectedLinkTypes;
    private final HashSet linkQueryLinkTypes;
    private String treeQueryLinkType;
    private final ListenerList modifiedListeners = new StandardListenerList();

    public QEQueryImpl(WorkItemClient workItemClient, String wiql, LinkQueryMode linkQueryMode) {
        this.workItemClient = workItemClient;
        this.linkQueryMode = linkQueryMode;
        this.queryType = QueryDefinitionUtil.getQueryType(linkQueryMode);
        this.sourceRows = new QEQueryRowCollectionImpl(this);
        this.targetRows = new QEQueryRowCollectionImpl(this);
        this.linkQueryLinkTypes = new HashSet();
        this.treeQueryLinkType = this.getDefaultTreeQueryLinkName();
        WIQLTranslator wiqlTranslator = new WIQLTranslator(this, new WIQLTranslatorFieldDefinitionCollectionAdatper(workItemClient.getFieldDefinitions()));
        wiqlTranslator.fromWIQL(wiql, true);
    }

    @Override
    public String getFilterExpression() {
        WIQLTranslator wiqlTranslator = new WIQLTranslator(this, new WIQLTranslatorFieldDefinitionCollectionAdatper(this.workItemClient.getFieldDefinitions()));
        return wiqlTranslator.asWIQL(false);
    }

    @Override
    public WorkItemClient getWorkItemClient() {
        return this.workItemClient;
    }

    @Override
    public QEQueryRowCollection getSourceRowCollection() {
        return this.sourceRows;
    }

    @Override
    public QEQueryRowCollection getTargetRowCollection() {
        return this.targetRows;
    }

    @Override
    public boolean getUseSelectedLinkTypes() {
        return this.useSelectedLinkTypes;
    }

    @Override
    public String[] getLinkQueryLinkTypes() {
        return this.linkQueryLinkTypes.toArray(new String[this.linkQueryLinkTypes.size()]);
    }

    @Override
    public String getTreeQueryLinkType() {
        return this.treeQueryLinkType;
    }

    @Override
    public void setUseSelectedLinkTypes(boolean useSelected) {
        if (this.useSelectedLinkTypes != useSelected) {
            this.useSelectedLinkTypes = useSelected;
            this.notifyModifiedListeners();
        }
    }

    @Override
    public void setTreeQueryLinkType(String referenceName) {
        if (this.treeQueryLinkType == null || !this.treeQueryLinkType.equals(referenceName)) {
            this.treeQueryLinkType = referenceName;
            this.notifyModifiedListeners();
        }
    }

    @Override
    public void addLinkQueryLinkType(String referenceName) {
        if (!this.linkQueryLinkTypes.contains(referenceName)) {
            this.linkQueryLinkTypes.add(referenceName);
            this.notifyModifiedListeners();
        }
    }

    @Override
    public void removeLinkQueryLinkType(String referenceName) {
        if (this.linkQueryLinkTypes.contains(referenceName)) {
            this.linkQueryLinkTypes.remove(referenceName);
            this.notifyModifiedListeners();
        }
    }

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public void setQueryType(QueryType value) {
        if (this.queryType != value) {
            this.queryType = value;
            this.setLinkQueryMode(QueryDefinitionUtil.getDefaultLinkQueryMode(value));
            this.notifyModifiedListeners();
        }
    }

    @Override
    public LinkQueryMode getLinkQueryMode() {
        return this.linkQueryMode;
    }

    @Override
    public void setLinkQueryMode(LinkQueryMode mode) {
        if (mode != this.linkQueryMode) {
            this.linkQueryMode = mode;
            this.notifyModifiedListeners();
        }
    }

    @Override
    public boolean isValid() {
        return this.getInvalidMessage() == null;
    }

    @Override
    public String getInvalidMessage() {
        int i;
        String message = null;
        QEQueryRow[] sourceRows = this.getSourceRowCollection().getRows();
        QEQueryRow[] targetRows = this.getTargetRowCollection().getRows();
        QEQueryGrouping sourceGrouping = this.getSourceRowCollection().getGrouping();
        QEQueryGrouping targetGrouping = this.getTargetRowCollection().getGrouping();
        for (i = 0; i < sourceRows.length; ++i) {
            message = this.getInvalidMessage(sourceGrouping, sourceRows[i], i, true);
            if (message == null) continue;
            return message;
        }
        for (i = 0; i < targetRows.length; ++i) {
            message = this.getInvalidMessage(targetGrouping, targetRows[i], i, false);
            if (message == null) continue;
            return message;
        }
        if (this.queryType == QueryType.ONE_HOP && this.linkQueryLinkTypes.size() == 0 && this.getUseSelectedLinkTypes()) {
            return Messages.getString("QEQueryImp.MustChooseAtLeastOneTypeOfLinkOrAny");
        }
        return null;
    }

    private String getInvalidMessage(QEQueryGrouping grouping, QEQueryRow row, int rowIx, boolean isSource) {
        String operator;
        String value;
        String message = null;
        if (this.isNullOrEmpty(row.getLogicalOperator()) && rowIx > 0 && (grouping.rowInGroup(rowIx) || !this.isNullOrEmpty(row.getFieldName()))) {
            message = Messages.getString("QEQueryImp.LogicalOperatorForRowNotFilledInCorrectlyFormat");
        }
        if (this.isNullOrEmpty(row.getFieldName()) && (rowIx == 0 && isSource || grouping.rowInGroup(rowIx))) {
            message = Messages.getString("QEQueryImp.FieldForRowNotFilledInCorrectlyFormat");
        }
        if (this.isNullOrEmpty(row.getOperator())) {
            message = Messages.getString("QEQueryImp.OperatorForRowNotRecognizedOrMissingFormat");
        } else {
            String value2;
            String operator2 = WIQLOperators.getInvariantOperator(row.getOperator());
            if (WIQLOperators.isFieldNameOperator(operator2)) {
                String fieldName = row.getValue();
                FieldDefinitionCollection fieldDefinitions = this.workItemClient.getFieldDefinitions();
                if (fieldName == null) {
                    message = Messages.getString("QEQueryImp.ValueForRowNotFilledInCorrectlyFormat");
                } else if (!fieldDefinitions.contains(fieldName)) {
                    message = Messages.getString("QEQueryImp.QueryReferencesFieldThatDoesNotExistInRowFormat");
                }
            } else if (!(this.isNullOrEmpty(row.getFieldName()) || this.isNullOrEmpty(value2 = row.getValue()) || value2.startsWith("@"))) {
                FieldDefinitionCollection fieldDefinitions = this.workItemClient.getFieldDefinitions();
                FieldDefinition fd = fieldDefinitions.get(row.getFieldName());
                if (fd.getFieldType() == FieldType.DATETIME) {
                    try {
                        DateTime.parse(value2, Locale.getDefault(), TimeZone.getDefault());
                    }
                    catch (DateTime.UncheckedParseException e) {
                        message = MessageFormat.format(Messages.getString("QEQueryImp.ValueInRowNotRecognizedAsDateTimeFormat"), value2);
                    }
                } else if (fd.getFieldType() == FieldType.DOUBLE) {
                    try {
                        NumberFormat.getInstance().parse(value2);
                    }
                    catch (ParseException e) {
                        message = MessageFormat.format(Messages.getString("QEQueryImp.ValueInRowNotRecognizedAsNumberFormat"), value2);
                    }
                } else if (fd.getFieldType() == FieldType.GUID) {
                    try {
                        new GUID(value2);
                    }
                    catch (IllegalArgumentException e) {
                        message = MessageFormat.format(Messages.getString("QEQueryImp.ValueInRowNotGuidFormat"), value2);
                    }
                }
            }
        }
        if (WIQLAdapter.fieldSupportsAnySyntax(this.workItemClient, row.getFieldName()) && (value = row.getValue()) != null && value.equalsIgnoreCase("[Any]") && !(operator = WIQLOperators.getInvariantOperator(row.getOperator())).equals("=")) {
            message = MessageFormat.format(Messages.getString("QEQueryImp.SpecialValueInRowCanOnlyBeUsedWithEqualsOperatorFormat"), WIQLOperators.getLocalizedOperator("[Any]"), WIQLOperators.getLocalizedOperator("="));
        }
        if (message != null) {
            return MessageFormat.format(message, new Integer(rowIx + 1).toString());
        }
        return null;
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private String getDefaultTreeQueryLinkName() {
        return "System.LinkTypes.Hierarchy-Forward";
    }

    @Override
    public void addModifiedListener(QEQueryModifiedListener listener) {
        this.modifiedListeners.addListener(listener);
    }

    @Override
    public void removeModifiedListener(QEQueryModifiedListener listener) {
        this.modifiedListeners.removeListener(listener);
    }

    public synchronized void notifyModifiedListeners() {
        QEQueryModifiedListener[] listeners = (QEQueryModifiedListener[])this.modifiedListeners.getListeners(new QEQueryModifiedListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].onQueryModified(this);
        }
    }
}

