/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.search.internal;

import com.microsoft.tfs.core.search.IVSSearchFilterToken;
import com.microsoft.tfs.core.search.IVSSearchQuery;
import com.microsoft.tfs.core.search.IVSSearchQueryParser;
import com.microsoft.tfs.core.search.IVSSearchToken;
import com.microsoft.tfs.core.search.internal.VSSearchFilterToken;
import com.microsoft.tfs.core.search.internal.VSSearchQuery;
import com.microsoft.tfs.core.search.internal.VSSearchToken;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class VSSearchQueryParser
implements IVSSearchQueryParser {
    @Override
    public IVSSearchQuery parse(String searchString) {
        Check.notNull(searchString, "searchString");
        return new VSSearchQuery(searchString);
    }

    @Override
    public String buildSearchString(IVSSearchQuery searchQuery) {
        Check.notNull(searchQuery, "searchQuery");
        int tokensCount = searchQuery.getTokens(0, null);
        IVSSearchToken[] tokens = new IVSSearchToken[tokensCount];
        searchQuery.getTokens(tokensCount, tokens);
        return this.buildSearchStringFromTokens(tokensCount, tokens);
    }

    @Override
    public String buildSearchStringFromTokens(int tokens, IVSSearchToken[] searchTokens) {
        Check.notNull(searchTokens, "searchTokens");
        ArrayList<String> tokensTexts = new ArrayList<String>(tokens);
        for (IVSSearchToken token : searchTokens) {
            tokensTexts.add(VSSearchQueryParser.buildTokenText(token));
        }
        return StringUtil.join(tokensTexts.toArray(new String[tokensTexts.size()]), Character.toString(' '));
    }

    @Override
    public IVSSearchToken getSearchToken(String tokenText) {
        Check.notNull(tokenText, "tokenText");
        String escapedTokenText = VSSearchQueryParser.escapeString(tokenText, AddQuotesMode.IF_EMPTY);
        return new VSSearchToken(escapedTokenText, 0, tokenText, 0);
    }

    @Override
    public IVSSearchFilterToken getSearchFilterToken(String filterField, String filterValue, int filterTokenType) {
        Check.notNull(filterField, "filterField");
        Check.notNull(filterValue, "filterValue");
        String filterTokenText = VSSearchQueryParser.buildFilterTokenText(filterField, AddQuotesMode.IF_EMPTY, filterValue, AddQuotesMode.ALWAYS, filterTokenType);
        int filterSeparator = VSSearchQueryParser.findFilterSeparator(filterTokenText);
        AtomicBoolean invalidEscape = new AtomicBoolean();
        String unescapedTokenText = VSSearchQueryParser.unescapeString(filterTokenText, invalidEscape);
        return new VSSearchFilterToken(filterTokenText, 0, unescapedTokenText, filterField, filterValue, filterTokenType, filterSeparator, 0);
    }

    public static boolean isQuote(char ch, int category) {
        return ch == '\"' || category == 29 || category == 30 || ch == '\uff02' || ch == '\uff07' || ch >= '\u2018' && ch <= '\u201f' || ch >= '\u300c' && ch <= '\u300f' || ch >= '\ufe41' && ch <= '\ufe44';
    }

    public static boolean isSpace(char ch, int category) {
        return ch == ' ' || category == 12;
    }

    public static boolean isEscape(char ch) {
        return ch == '\\';
    }

    public static boolean isExcludeFilter(char ch) {
        return ch == '-';
    }

    public static boolean isFilterSeparator(char ch) {
        return ch == ':' || ch == '=';
    }

    public static void parseSearchString(String searchString, TokenFoundCallback tokenFoundCallback) {
        int tokenStart = -1;
        boolean quoteMode = false;
        int stringLength = searchString.length();
        StringBuilder unquotedToken = new StringBuilder(stringLength);
        for (int i = 0; i < stringLength; ++i) {
            int category;
            char ch = searchString.charAt(i);
            if (VSSearchQueryParser.isSpace(ch, category = Character.getType(ch))) {
                if (quoteMode) {
                    unquotedToken.append(ch);
                    continue;
                }
                if (tokenStart == -1) continue;
                VSSearchQueryParser.parseTokenString(searchString, tokenStart, i - tokenStart, unquotedToken.toString(), quoteMode, tokenFoundCallback);
                tokenStart = -1;
                unquotedToken.setLength(0);
                continue;
            }
            if (tokenStart == -1) {
                tokenStart = i;
            }
            if (VSSearchQueryParser.isQuote(ch, category)) {
                quoteMode = !quoteMode;
                continue;
            }
            unquotedToken.append(ch);
            if (!VSSearchQueryParser.isEscape(ch) || i + 1 >= stringLength) continue;
            unquotedToken.append(searchString.charAt(++i));
        }
        if (tokenStart != -1) {
            VSSearchQueryParser.parseTokenString(searchString, tokenStart, stringLength - tokenStart, unquotedToken.toString(), quoteMode, tokenFoundCallback);
        }
    }

    static void parseTokenString(String searchString, int tokenStart, int tokenLength, String unquotedToken, boolean quoteMode, TokenFoundCallback tokenFoundCallback) {
        int filterSeparator;
        VSSearchToken token = null;
        String originalTokenText = searchString.substring(tokenStart, tokenStart + tokenLength);
        int parseError = 0;
        if (quoteMode) {
            parseError |= 1;
        }
        AtomicBoolean invalidEscape = new AtomicBoolean(false);
        String parsedTokenText = VSSearchQueryParser.unescapeString(unquotedToken, invalidEscape);
        if (invalidEscape.get()) {
            parseError |= 2;
        }
        if ((filterSeparator = VSSearchQueryParser.findFilterSeparator(unquotedToken)) == -1) {
            token = new VSSearchToken(originalTokenText, tokenStart, parsedTokenText, parseError);
        } else {
            int filterTokenType = 0;
            if (unquotedToken.charAt(filterSeparator) == '=') {
                filterTokenType |= 2;
            }
            AtomicBoolean invalidFilterFieldEscape = new AtomicBoolean(false);
            String filterField = VSSearchQueryParser.unescapeString(unquotedToken.substring(0, filterSeparator), invalidFilterFieldEscape);
            AtomicBoolean invalidFilterValueEscape = new AtomicBoolean(false);
            String filterValue = VSSearchQueryParser.unescapeString(unquotedToken.substring(filterSeparator + 1), invalidFilterValueEscape);
            if (invalidFilterFieldEscape.get() || invalidFilterValueEscape.get()) {
                parseError |= 2;
            }
            if (filterField == null || filterField.trim().length() == 0) {
                parseError |= 4;
            } else if (VSSearchQueryParser.isExcludeFilter(filterField.charAt(0))) {
                filterTokenType |= 1;
                if ((filterField = filterField.substring(1)) == null || filterField.trim().length() == 0) {
                    parseError |= 4;
                }
            }
            if (filterValue == null || filterValue.length() == 0) {
                parseError |= 8;
            }
            filterSeparator = VSSearchQueryParser.findFilterSeparator(originalTokenText);
            token = new VSSearchFilterToken(originalTokenText, tokenStart, parsedTokenText, filterField, filterValue, filterTokenType, filterSeparator, parseError);
        }
        tokenFoundCallback.call(token);
    }

    public static int findFilterSeparator(String tokenString) {
        int stringLength = tokenString.length();
        for (int i = 0; i < stringLength; ++i) {
            char ch = tokenString.charAt(i);
            if (VSSearchQueryParser.isEscape(ch)) {
                ++i;
                continue;
            }
            if (!VSSearchQueryParser.isFilterSeparator(ch)) continue;
            return i;
        }
        return -1;
    }

    public static String unescapeString(String tokenString, AtomicBoolean invalidEscape) {
        invalidEscape.set(false);
        int stringLength = tokenString.length();
        StringBuilder unescapedString = new StringBuilder(stringLength);
        for (int i = 0; i < stringLength; ++i) {
            char ch = tokenString.charAt(i);
            if (!VSSearchQueryParser.isEscape(ch)) {
                unescapedString.append(ch);
                continue;
            }
            if (i + 1 < stringLength) {
                char ch2 = tokenString.charAt(++i);
                int category = Character.getType(ch2);
                if (VSSearchQueryParser.isEscape(ch2) || VSSearchQueryParser.isFilterSeparator(ch2) || VSSearchQueryParser.isQuote(ch2, category)) {
                    unescapedString.append(ch2);
                    continue;
                }
                invalidEscape.set(true);
                unescapedString.append(ch);
                unescapedString.append(ch2);
                continue;
            }
            invalidEscape.set(true);
            unescapedString.append(ch);
        }
        return unescapedString.toString();
    }

    public static String escapeString(String tokenString, AddQuotesMode addQuotesMode) {
        return VSSearchQueryParser.escapeString(tokenString, addQuotesMode, false);
    }

    public static String escapeString(String tokenString, AddQuotesMode addQuotesMode, boolean isFilterFieldString) {
        boolean addQuotes = addQuotesMode == AddQuotesMode.ALWAYS;
        int stringLength = tokenString.length();
        StringBuilder escapedString = new StringBuilder(2 * stringLength);
        if (stringLength == 0) {
            addQuotes = addQuotesMode != AddQuotesMode.DEFAULT;
        } else {
            for (int i = 0; i < stringLength; ++i) {
                int category;
                char ch = tokenString.charAt(i);
                if (VSSearchQueryParser.isSpace(ch, category = Character.getType(ch))) {
                    addQuotes = true;
                }
                if (VSSearchQueryParser.isEscape(ch) || VSSearchQueryParser.isFilterSeparator(ch) || VSSearchQueryParser.isQuote(ch, category) || isFilterFieldString && i == 0 && VSSearchQueryParser.isExcludeFilter(ch)) {
                    escapedString.append('\\');
                }
                escapedString.append(ch);
            }
        }
        if (addQuotes) {
            escapedString.insert(0, '\"');
            escapedString.append('\"');
        }
        return escapedString.toString();
    }

    static String buildTokenText(IVSSearchToken token) {
        IVSSearchFilterToken filterToken;
        IVSSearchFilterToken iVSSearchFilterToken = filterToken = token instanceof IVSSearchFilterToken ? (IVSSearchFilterToken)token : null;
        if (filterToken == null) {
            return VSSearchQueryParser.escapeString(token.getParsedTokenText(), token.getOriginalTokenText() == null || token.getOriginalTokenText().length() == 0 ? AddQuotesMode.DEFAULT : AddQuotesMode.IF_EMPTY);
        }
        String originalField = StringUtil.trimBegin(filterToken.getOriginalTokenText().substring(0, filterToken.getFilterSeparatorPosition()));
        if (originalField.length() > 0 && VSSearchQueryParser.isExcludeFilter(originalField.charAt(0))) {
            originalField = originalField.substring(1);
        }
        boolean originalFieldIsWhitespace = originalField.trim().length() == 0;
        boolean originalValueIsWhitespace = filterToken.getOriginalTokenText().substring(filterToken.getFilterSeparatorPosition() + 1).trim().length() == 0;
        return VSSearchQueryParser.buildFilterTokenText(filterToken.getFilterField(), originalFieldIsWhitespace ? AddQuotesMode.DEFAULT : AddQuotesMode.IF_EMPTY, filterToken.getFilterValue(), originalValueIsWhitespace ? AddQuotesMode.DEFAULT : AddQuotesMode.IF_EMPTY, filterToken.getFilterTokenType());
    }

    static String buildFilterTokenText(String unescapedFilterField, AddQuotesMode addQuotesModeField, String unescapedFilterValue, AddQuotesMode addQuotesModeValue, int filterTokenType) {
        String filterField = VSSearchQueryParser.escapeString(unescapedFilterField, addQuotesModeField, true);
        String filterValue = VSSearchQueryParser.escapeString(unescapedFilterValue, addQuotesModeValue);
        if ((filterTokenType & 1) != 0) {
            filterField = '-' + filterField;
        }
        char filterSeparator = (filterTokenType & 2) != 0 ? (char)'=' : ':';
        return StringUtil.join(new String[]{filterField, filterValue}, Character.toString(filterSeparator));
    }

    private static class SyntaxCharacters {
        public static final char SPACE_SEPARATOR = ' ';
        public static final char QUOTE = '\"';
        public static final char ESCAPE = '\\';
        public static final char PARTIAL_MATCH_FILTER_SEPARATOR = ':';
        public static final char EXACT_MATCH_FILTER_SEPARATOR = '=';
        public static final char EXCLUDE_FILTER = '-';

        private SyntaxCharacters() {
        }
    }

    private static enum AddQuotesMode {
        DEFAULT,
        IF_EMPTY,
        ALWAYS;

    }

    public static interface TokenFoundCallback {
        public void call(IVSSearchToken var1);
    }
}

