/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.jni.NTLMEngine;
import com.microsoft.tfs.jni.NegotiateEngine;
import com.microsoft.tfs.util.Check;

public class CredentialsUtils {
    private CredentialsUtils() {
    }

    public static boolean needsPassword(Credentials credentials) {
        Check.notNull(credentials, "credentials");
        return credentials instanceof UsernamePasswordCredentials && ((UsernamePasswordCredentials)credentials).getPassword() == null;
    }

    public static boolean supportsDefaultCredentials() {
        return NegotiateEngine.getInstance().isAvailable() && NegotiateEngine.getInstance().supportsCredentialsDefault() || NTLMEngine.getInstance().isAvailable() && NTLMEngine.getInstance().supportsCredentialsDefault();
    }

    public static boolean supportsSpecifiedCredentials() {
        return NegotiateEngine.getInstance().isAvailable() && NegotiateEngine.getInstance().supportsCredentialsSpecified() || NTLMEngine.getInstance().isAvailable() && NTLMEngine.getInstance().supportsCredentialsSpecified();
    }
}

