/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream.decoder.entry;

import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedEntryDescriptor;
import com.microsoft.tfs.jni.appleforked.stream.decoder.entry.AppleForkedEntryDecoder;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.chunkingcodec.ByteArrayChunkedDecoder;
import java.io.File;

public class AppleForkedCommentDecoder
extends ByteArrayChunkedDecoder
implements AppleForkedEntryDecoder {
    private String filename;
    private byte[] comment;

    public AppleForkedCommentDecoder(AppleForkedEntryDescriptor descriptor, File file) {
        super((int)descriptor.getLength());
        Check.isTrue(descriptor.getType() == 4L, "descriptor.getType() == AppleForkedConstants.ID_COMMENT");
        Check.notNull(file, "file");
        try {
            this.filename = file.getCanonicalPath();
        }
        catch (Exception e) {
            this.filename = file.getAbsolutePath();
        }
    }

    @Override
    protected void finish(byte[] buffer) {
        this.comment = buffer;
    }

    @Override
    public void close() {
        if (this.filename != null && this.comment != null && this.comment.length > 0) {
            FileSystemUtils.getInstance().setMacExtendedAttribute(this.filename, "com.apple.metadata:kMDItemFinderComment", this.comment);
        }
    }
}

