/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.internal.platformmisc;

import com.microsoft.tfs.jni.PlatformMisc;
import com.microsoft.tfs.jni.loader.NativeLoader;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import java.io.File;
import java.io.IOException;

public class NativePlatformMisc
implements PlatformMisc {
    @Override
    public String getHomeDirectory(String username) {
        Check.notNull(username, "username");
        if (!Platform.isCurrentPlatform(Platform.GENERIC_UNIX)) {
            return null;
        }
        return NativePlatformMisc.nativeGetHomeDirectory(username);
    }

    @Override
    public boolean changeCurrentDirectory(String directory) {
        Check.notNull(directory, "directory");
        if (NativePlatformMisc.nativeChangeCurrentDirectory(directory) == 0) {
            try {
                System.setProperty("user.dir", new File(directory).getCanonicalPath());
            }
            catch (IOException e) {
                System.setProperty("user.dir", new File(directory).getAbsolutePath());
            }
            return true;
        }
        return false;
    }

    @Override
    public int getDefaultCodePage() {
        if (!Platform.isCurrentPlatform(Platform.WINDOWS)) {
            return -1;
        }
        return NativePlatformMisc.nativeGetDefaultCodePage();
    }

    @Override
    public String getComputerName() {
        String name = NativePlatformMisc.nativeGetComputerName();
        if (name == null || name.length() == 0) {
            return null;
        }
        return name;
    }

    @Override
    public String getEnvironmentVariable(String name) {
        Check.notNullOrEmpty(name, "name");
        return NativePlatformMisc.nativeGetEnvironmentVariable(name);
    }

    @Override
    public String expandEnvironmentString(String value) {
        Check.notNull(value, "value");
        if (!Platform.isCurrentPlatform(Platform.WINDOWS)) {
            return value;
        }
        return NativePlatformMisc.nativeExpandEnvironmentString(value);
    }

    @Override
    public String getCurrentIdentityUser() {
        return NativePlatformMisc.nativeGetCurrentIdentityUser();
    }

    @Override
    public String getWellKnownSID(int wellKnownSIDType, String domainSIDString) {
        return NativePlatformMisc.nativeGetWellKnownSID(wellKnownSIDType, domainSIDString);
    }

    private static native int nativeChangeCurrentDirectory(String var0);

    private static native String nativeGetComputerName();

    private static native String nativeGetEnvironmentVariable(String var0);

    private static native int nativeGetDefaultCodePage();

    private static native String nativeGetCurrentIdentityUser();

    private static native String nativeExpandEnvironmentString(String var0);

    private static native String nativeGetWellKnownSID(int var0, String var1);

    private static native String nativeGetHomeDirectory(String var0);

    static {
        NativeLoader.loadLibraryAndLogError("native_misc");
    }
}

