/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtil {
    public static final int MAX_COMMENT_DISPLAY_LENGTH = 120;
    public static final String ELLIPSIS = "...";
    public static final String EMPTY = "";
    public static final String UTF8_CHARSET = "UTF-8";
    private static final String PASSWORD_TOKEN = "Password=";
    private static final String PWD_TOKEN = "Pwd=";
    private static final String ACCOUNT_KEY_TOKEN = "AccountKey=";
    private static final String PASSWORD_MASK = "******";
    private static final List<Character> VALID_PASSWORD_ENDING = Arrays.asList(Character.valueOf(';'), Character.valueOf('\''), Character.valueOf('\"'));
    private static String[] TOKENS_TO_SCRUB = new String[]{"Password=", "Pwd=", "AccountKey="};

    public static String trimBegin(String s) {
        int index;
        Check.notNull(s, "s");
        int length = s.length();
        for (index = 0; index < length && s.charAt(index) <= ' '; ++index) {
        }
        return index > 0 ? s.substring(index) : s;
    }

    public static String trimBegin(String s, char ch) {
        int index;
        Check.notNull(s, "s");
        int length = s.length();
        for (index = 0; index < length && s.charAt(index) == ch; ++index) {
        }
        return index > 0 ? s.substring(index) : s;
    }

    public static String trimBegin(String s, char[] trimChars) {
        int index;
        Check.notNull(s, "s");
        int length = s.length();
        for (index = 0; index < length && StringUtil.isTrimChar(s.charAt(index), trimChars); ++index) {
        }
        return index > 0 ? s.substring(index) : s;
    }

    public static String trimEnd(String s) {
        int index;
        Check.notNull(s, "s");
        int length = s.length();
        for (index = s.length() - 1; index >= 0 && s.charAt(index) <= ' '; --index) {
        }
        return index < length - 1 ? s.substring(0, index + 1) : s;
    }

    public static String trimEnd(String s, char ch) {
        int index;
        Check.notNull(s, "s");
        int length = s.length();
        for (index = s.length() - 1; index >= 0 && s.charAt(index) == ch; --index) {
        }
        return index < length - 1 ? s.substring(0, index + 1) : s;
    }

    public static String trimEnd(String s, char[] trimChars) {
        int index;
        Check.notNull(s, "s");
        int length = s.length();
        for (index = s.length() - 1; index >= 0 && StringUtil.isTrimChar(s.charAt(index), trimChars); --index) {
        }
        return index < length - 1 ? s.substring(0, index + 1) : s;
    }

    private static boolean isTrimChar(char ch, char[] trimChars) {
        for (int i = 0; i < trimChars.length; ++i) {
            if (trimChars[i] != ch) continue;
            return true;
        }
        return false;
    }

    public static String[] split(String delimiters, String text) {
        if (delimiters == null || delimiters.length() == 0) {
            throw new IllegalArgumentException("Must pass a delimiter.");
        }
        if (delimiters.indexOf(39) >= 0 || delimiters.indexOf(34) >= 0) {
            throw new IllegalArgumentException("' and \" are not allowed as delimiters");
        }
        if ((delimiters.indexOf(45) >= 0 || delimiters.indexOf(91) >= 0 || delimiters.indexOf(93) >= 0 || delimiters.indexOf(38) >= 0) && delimiters.length() > 1) {
            throw new IllegalArgumentException("-,[,] or & are not allowed in-conjunction with other delimiters ");
        }
        if (text == null) {
            return new String[0];
        }
        String delimRegex = "\"[^\"]*\"|'[^']*'|[^" + delimiters + "]+";
        Pattern pattern = Pattern.compile(delimRegex);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> matches = new ArrayList<String>();
        if (matcher.find()) {
            do {
                String matchText;
                if ((matchText = matcher.group().trim()).startsWith("\"") && matchText.endsWith("\"") || matchText.startsWith("'") && matchText.endsWith("'")) {
                    matchText = matchText.substring(1, matchText.length() - 1);
                }
                matches.add(matchText);
            } while (matcher.find());
        }
        return matches.toArray(new String[matches.size()]);
    }

    public static String[] splitRemoveEmpties(String stringToSplit, String regex) {
        Check.notNull(stringToSplit, "stringToSplit");
        Check.notNull(regex, "regex");
        String[] strings = stringToSplit.split(regex);
        boolean hasEmpties = false;
        for (String string : strings) {
            if (!StringUtil.isNullOrEmpty(string)) continue;
            hasEmpties = true;
            break;
        }
        if (!hasEmpties) {
            return strings;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String string : strings) {
            if (StringUtil.isNullOrEmpty(string)) continue;
            ret.add(string);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static boolean containsStringInsensitive(String[] candidates, String searchString) {
        Check.notNull(candidates, "candidates");
        Check.notNull(searchString, "searchString");
        for (int i = 0; i < candidates.length; ++i) {
            if (!searchString.equalsIgnoreCase(candidates[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String s, String searchFor) {
        Check.notNull(s, "s");
        Check.notNull(searchFor, "searchFor");
        return s.toLowerCase().contains(searchFor.toLowerCase());
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String replaceOnce(String text, String repl, String with) {
        return StringUtil.replace(text, repl, with, 1);
    }

    public static String replace(String text, String repl, String with) {
        return StringUtil.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (StringUtil.isNullOrEmpty(text) || StringUtil.isNullOrEmpty(repl) || with == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(repl, start);
        if (end == -1) {
            return text;
        }
        int replLength = repl.length();
        int increase = with.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(repl, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String join(String[] strings, String joinString) {
        StringBuffer buffer = new StringBuffer();
        if (strings != null && strings.length > 0) {
            buffer.append(strings[0]);
            for (int i = 1; i < strings.length; ++i) {
                buffer.append(joinString);
                buffer.append(strings[i]);
            }
        }
        return buffer.toString();
    }

    public static boolean startsWithIgnoreCase(String value, String possiblePrefix) {
        if (value == null || possiblePrefix == null || value.length() < possiblePrefix.length()) {
            return false;
        }
        return value.substring(0, possiblePrefix.length()).equalsIgnoreCase(possiblePrefix);
    }

    public static String formatCommentForOneLine(String comment) {
        if (StringUtil.isNullOrEmpty(comment)) {
            return EMPTY;
        }
        comment = comment.replace('\n', ' ').replace('\r', ' ');
        if ((comment = StringUtil.replace(comment, "\t", "    ").trim()).length() > 120) {
            comment = comment.substring(0, 117);
            comment = comment + ELLIPSIS;
        }
        return comment;
    }

    public static String join(String delimiter, List<?> values) {
        StringBuilder sb = new StringBuilder();
        for (Object v : values) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String ScrubPassword(String message) {
        return StringUtil.ScrubPassword(message, true);
    }

    public static String ScrubPassword(String message, boolean assertOnDetection) {
        if (StringUtil.isNullOrEmpty(message)) {
            return message;
        }
        String msg = message;
        for (String token : TOKENS_TO_SCRUB) {
            msg = StringUtil.ScrubSecret(msg, token, PASSWORD_MASK, assertOnDetection);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ScrubSecret(String message, String token, String mask, boolean assertOnDetection) {
        int startIndex = 0;
        String msg = message;
        while ((startIndex = msg.toUpperCase().indexOf(token.toUpperCase(), startIndex)) >= 0) {
            if (msg.toUpperCase().indexOf(token.toUpperCase() + mask.toUpperCase()) == startIndex) {
                startIndex += token.length() + mask.length();
            } else {
                try {
                    int i;
                    int endIndex = msg.length() - 1;
                    if (msg.charAt(startIndex += token.length()) == '\"' || msg.charAt(startIndex) == '\'') {
                        for (i = startIndex + 1; i < msg.length() - 1; ++i) {
                            if (msg.charAt(startIndex) != msg.charAt(i)) continue;
                            if (msg.charAt(startIndex) == msg.charAt(i + 1)) {
                                ++i;
                                continue;
                            }
                            endIndex = i;
                            break;
                        }
                    } else {
                        for (i = startIndex + 1; i < msg.length(); ++i) {
                            if (!VALID_PASSWORD_ENDING.contains(Character.valueOf(msg.charAt(i)))) continue;
                            endIndex = i - 1;
                            break;
                        }
                    }
                    msg = msg.substring(0, startIndex) + mask + msg.substring(endIndex + 1);
                    if (assertOnDetection) {
                        Check.isTrue(false, MessageFormat.format("Message contains an unmasked password. Message: {0}", msg));
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    startIndex += mask.length();
                }
            }
            if (startIndex < msg.length()) continue;
        }
        return msg;
    }

    public static String newString(char padChar, int width) {
        char[] buf = new char[width];
        for (int i = 0; i < width; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static String pad(String s, int width, boolean leftJustified, char padChar) {
        if (leftJustified) {
            return (s + StringUtil.newString(' ', width)).substring(0, width);
        }
        return (StringUtil.newString(' ', width) + s).substring(s.length());
    }

    public static String pad(String s, int width, boolean leftJustified) {
        return StringUtil.pad(s, width, leftJustified, ' ');
    }

    public static String pad(String s, int width) {
        return StringUtil.pad(s, width, true, ' ');
    }

    public static String pad(Number n, int width, char padChar) {
        return StringUtil.pad(n.toString(), width, false, padChar);
    }

    public static String pad(Number n, int width) {
        return StringUtil.pad(n, width, ' ');
    }

    public static int toInt(String s) {
        int number;
        switch (s.charAt(s.length() - 1)) {
            case 'K': 
            case 'k': {
                number = Integer.parseInt(s.substring(0, s.length() - 1).trim()) * 1024;
                break;
            }
            case 'M': 
            case 'm': {
                number = Integer.parseInt(s.substring(0, s.length() - 1).trim()) * 1024 * 1024;
                break;
            }
            default: {
                number = Integer.parseInt(s.trim());
            }
        }
        return number;
    }

    public static String escapeXml(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;");
    }
}

