/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.logging;

import com.google.common.base.Preconditions;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.LogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.log.interaction.GlobalInteractionLogIndex;
import com.teamscale.core.log.interaction.ProjectInteractionLogIndex;
import com.teamscale.core.log.interaction.ShortInteractionLog;
import com.teamscale.core.log.js.DetailedJavaScriptErrorLog;
import com.teamscale.core.log.js.GlobalJavaScriptErrorLogIndex;
import com.teamscale.core.log.js.ProjectJavaScriptErrorLogIndex;
import com.teamscale.core.log.js.ShortJavaScriptErrorLog;
import com.teamscale.core.log.profiler.GlobalProfilerLogIndex;
import com.teamscale.core.log.service.DetailedServiceLog;
import com.teamscale.core.log.service.GlobalCriticalEventServiceLogIndex;
import com.teamscale.core.log.service.GlobalServiceLogIndex;
import com.teamscale.core.log.service.ProjectCriticalEventServiceLogIndex;
import com.teamscale.core.log.service.ProjectServiceLogIndex;
import com.teamscale.core.log.service.ShortCriticalEventServiceLog;
import com.teamscale.core.log.service.ShortServiceLog;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import com.teamscale.core.log.worker.GlobalCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogDigestIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogDigestIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogIndex;
import com.teamscale.core.log.worker.ShortCriticalEventWorkerLog;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.core.log.worker.WorkerLogDigestIndexBase;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.framework.util.ResponseUtils;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.BiFunctionWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.io.LimitedWriter;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class LogServiceUtils {
    public static final String ALL_PROJECTS = "All Projects";
    public static final String MAINTENANCE_PROJECTS = "Maintenance Jobs";

    public static boolean requiresGlobalLog(IProjectId projectId) {
        return projectId == null || SchedulingConstants.isMaintenance((IProjectId)projectId);
    }

    public static LogIndexBase<ShortWorkerLog, DetailedWorkerLog> getProjectWorkerLogIndex(IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        Preconditions.checkNotNull((Object)projectId, (Object)"project must not be null.");
        return (LogIndexBase)indexLayer.openProjectIndex(projectId, ProjectWorkerLogIndex.class, null);
    }

    public static ProjectWorkerLogIndex getProjectWorkerLogIndex(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return (ProjectWorkerLogIndex)projectStorageSystem.openProjectIndex(ProjectWorkerLogIndex.class, null);
    }

    private static List<ProjectInfo> getProjects(IndexLayer indexLayer) throws StorageException {
        return ((ProjectIndex)indexLayer.openGlobalIndex(ProjectIndex.class)).getAllProjectInfos();
    }

    public static LogIndexBase<ShortWorkerLog, DetailedWorkerLog> getGlobalWorkerLogIndex(IndexLayer indexLayer) throws StorageException {
        return (LogIndexBase)indexLayer.openGlobalIndex(GlobalWorkerLogIndex.class);
    }

    public static LogIndexBase<ShortInteractionLog, DetailedWorkerLog> getGlobalInteractionLogIndex(IndexLayer indexLayer) throws StorageException {
        return (LogIndexBase)indexLayer.openGlobalIndex(GlobalInteractionLogIndex.class);
    }

    public static PairList<PublicProjectId, LogIndexBase<ShortWorkerLog, DetailedWorkerLog>> getAllWorkerLogIndexes(IndexLayer indexLayer) throws StorageException {
        PairList result = new PairList();
        result.add((Object)new PublicProjectId(MAINTENANCE_PROJECTS), (Object)((LogIndexBase)indexLayer.openGlobalIndex(GlobalWorkerLogIndex.class)));
        for (ProjectInfo project : LogServiceUtils.getProjects(indexLayer)) {
            result.add((Object)project.getPrimaryPublicId(), (Object)((LogIndexBase)indexLayer.openNonHistorizedProjectIndex(ProjectWorkerLogIndex.class, (IProjectId)project.getInternalId())));
        }
        return result;
    }

    public static PairList<PublicProjectId, LogIndexBase<ShortInteractionLog, DetailedWorkerLog>> getAllInteractionLogIndexes(IndexLayer indexLayer) throws StorageException {
        PairList result = new PairList();
        result.add((Object)new PublicProjectId(MAINTENANCE_PROJECTS), (Object)((LogIndexBase)indexLayer.openGlobalIndex(GlobalInteractionLogIndex.class)));
        for (ProjectInfo project : LogServiceUtils.getProjects(indexLayer)) {
            result.add((Object)project.getPrimaryPublicId(), (Object)((LogIndexBase)indexLayer.openNonHistorizedProjectIndex(ProjectInteractionLogIndex.class, project)));
        }
        return result;
    }

    public static Map<PublicProjectId, WorkerLogDigestIndexBase> getDigestIndexesForProjects(IndexLayer indexLayer, Collection<PublicProjectId> projects) throws StorageException {
        HashMap<PublicProjectId, WorkerLogDigestIndexBase> result = new HashMap<PublicProjectId, WorkerLogDigestIndexBase>();
        for (PublicProjectId project : projects) {
            if (SchedulingConstants.isMaintenance((IProjectId)project)) {
                result.put(project, (WorkerLogDigestIndexBase)indexLayer.openGlobalIndex(GlobalWorkerLogDigestIndex.class));
                continue;
            }
            CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)project);
            result.put(project, (WorkerLogDigestIndexBase)projectStorageSystem.openProjectIndex(ProjectWorkerLogDigestIndex.class, null));
        }
        return result;
    }

    public static PairList<PublicProjectId, LogIndexBase<ShortCriticalEventWorkerLog, DetailedWorkerLog>> getAllCriticalWorkerLogIndexes(IndexLayer indexLayer) throws StorageException {
        PairList result = new PairList();
        GlobalCriticalEventWorkerLogIndex criticalEventWorkerLogIndex = (GlobalCriticalEventWorkerLogIndex)indexLayer.openGlobalIndex(GlobalCriticalEventWorkerLogIndex.class);
        result.add((Object)new PublicProjectId(MAINTENANCE_PROJECTS), (Object)criticalEventWorkerLogIndex);
        for (ProjectInfo project : LogServiceUtils.getProjects(indexLayer)) {
            result.add((Object)project.getPrimaryPublicId(), (Object)LogServiceUtils.openProjectCriticalEventWorkerLogIndex(indexLayer, project));
        }
        return result;
    }

    private static ProjectCriticalEventWorkerLogIndex openProjectCriticalEventWorkerLogIndex(IndexLayer indexLayer, ProjectInfo project) throws StorageException {
        return (ProjectCriticalEventWorkerLogIndex)indexLayer.openNonHistorizedProjectIndex(ProjectCriticalEventWorkerLogIndex.class, project);
    }

    public static ProjectCriticalEventServiceLogIndex getProjectCriticalEventLogIndex(IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        return (ProjectCriticalEventServiceLogIndex)indexLayer.openProjectIndex(projectId, ProjectCriticalEventServiceLogIndex.class, null);
    }

    public static ProjectInteractionLogIndex getProjectInteractionLogIndex(IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        return (ProjectInteractionLogIndex)indexLayer.openProjectIndex(projectId, ProjectInteractionLogIndex.class, null);
    }

    public static GlobalCriticalEventWorkerLogIndex getGlobalCriticalEventWorkerLogIndex(IndexLayer indexLayer) throws StorageException {
        return (GlobalCriticalEventWorkerLogIndex)indexLayer.openGlobalIndex(GlobalCriticalEventWorkerLogIndex.class);
    }

    public static ProjectCriticalEventWorkerLogIndex getProjectCriticalEventWorkerLogIndex(IndexLayer indexLayer, PublicProjectId projectId) throws StorageException {
        return (ProjectCriticalEventWorkerLogIndex)indexLayer.openNonHistorizedProjectIndex(ProjectCriticalEventWorkerLogIndex.class, (IProjectId)projectId);
    }

    public static GlobalCriticalEventServiceLogIndex getGlobalCriticalEventLogIndex(IndexLayer indexLayer) throws StorageException {
        return (GlobalCriticalEventServiceLogIndex)indexLayer.openGlobalIndex(GlobalCriticalEventServiceLogIndex.class);
    }

    public static PairList<PublicProjectId, LogIndexBase<ShortCriticalEventServiceLog, DetailedServiceLog>> getAllCriticalEventLogIndexes(IndexLayer indexLayer) throws StorageException {
        PairList result = new PairList();
        result.add((Object)new PublicProjectId(MAINTENANCE_PROJECTS), (Object)LogServiceUtils.getGlobalCriticalEventLogIndex(indexLayer));
        for (ProjectInfo project : LogServiceUtils.getProjects(indexLayer)) {
            result.add((Object)project.getPrimaryPublicId(), (Object)LogServiceUtils.getProjectCriticalEventLogIndex(indexLayer, (IProjectId)project.getPrimaryPublicId()));
        }
        return result;
    }

    public static GlobalServiceLogIndex getGlobalServiceLogIndex(IndexLayer indexLayer) throws StorageException {
        return (GlobalServiceLogIndex)indexLayer.openGlobalIndex(GlobalServiceLogIndex.class);
    }

    public static LogIndexBase<ShortJavaScriptErrorLog, DetailedJavaScriptErrorLog> getGlobalJavaScriptErrorLogIndex(IndexLayer indexLayer) throws StorageException {
        return (LogIndexBase)indexLayer.openGlobalIndex(GlobalJavaScriptErrorLogIndex.class);
    }

    public static LogIndexBase<ShortJavaScriptErrorLog, DetailedJavaScriptErrorLog> getProjectJavaScriptErrorLogIndex(IndexLayer indexLayer, PublicProjectId project) throws StorageException {
        return (LogIndexBase)indexLayer.openProjectIndex((IProjectId)project, ProjectJavaScriptErrorLogIndex.class, null);
    }

    public static PairList<PublicProjectId, LogIndexBase<ShortJavaScriptErrorLog, DetailedJavaScriptErrorLog>> getAllJavaScriptErrorLogIndexes(IndexLayer indexLayer) throws StorageException {
        PairList result = new PairList();
        result.add((Object)SchedulingConstants.MAINTENANCE_PROJECT_PUBLIC_NAME, LogServiceUtils.getGlobalJavaScriptErrorLogIndex(indexLayer));
        for (ProjectInfo project : LogServiceUtils.getProjects(indexLayer)) {
            result.add((Object)project.getPrimaryPublicId(), LogServiceUtils.getProjectJavaScriptErrorLogIndex(indexLayer, project.getPrimaryPublicId()));
        }
        return result;
    }

    public static LogIndexBase<ShortServiceLog, DetailedServiceLog> getProjectServiceLogIndex(IndexLayer indexLayer, IProjectId project) throws StorageException {
        return (LogIndexBase)indexLayer.openProjectIndex(project, ProjectServiceLogIndex.class, null);
    }

    public static PairList<PublicProjectId, LogIndexBase<ShortServiceLog, DetailedServiceLog>> getAllServiceLogIndexes(IndexLayer indexLayer) throws StorageException {
        PairList result = new PairList();
        result.add((Object)new PublicProjectId(MAINTENANCE_PROJECTS), (Object)LogServiceUtils.getGlobalServiceLogIndex(indexLayer));
        for (ProjectInfo project : LogServiceUtils.getProjects(indexLayer)) {
            result.add((Object)project.getPrimaryPublicId(), LogServiceUtils.getProjectServiceLogIndex(indexLayer, (IProjectId)project.getPrimaryPublicId()));
        }
        return result;
    }

    public static GlobalProfilerLogIndex getProfilerLogIndex(IndexLayer indexLayer, UUID profilerId) throws StorageException {
        GlobalProfilerLogIndex result = (GlobalProfilerLogIndex)indexLayer.openGlobalIndex(GlobalProfilerLogIndex.class);
        result.setProfiler(profilerId);
        return result;
    }

    public static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> void deleteLogEntries(LogFilteringParameters logFilteringParameters, LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index) throws StorageException {
        List<SHORT_LOG_ENTRY> entriesToDelete = LogServiceUtils.getShortLogsWithoutSortAndTruncate(logFilteringParameters, index);
        if (entriesToDelete.isEmpty()) {
            return;
        }
        index.deleteLogEntries(entriesToDelete);
    }

    private static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> List<SHORT_LOG_ENTRY> getShortLogsWithoutSortAndTruncate(LogFilteringParameters logFilteringParameters, LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index) throws StorageException {
        boolean newestEntriesFirst = LogServiceUtils.shouldSortByNewestEntriesFirst(logFilteringParameters);
        ELogLevel minLogLevel = logFilteringParameters.getMinLogLevel();
        long startTimestamp = logFilteringParameters.getStartTimestamp();
        long endTimestamp = logFilteringParameters.getEndTimestamp();
        if (newestEntriesFirst) {
            startTimestamp = logFilteringParameters.getEndTimestamp();
            endTimestamp = logFilteringParameters.getStartTimestamp();
        }
        List<SHORT_LOG_ENTRY> logEntries = new ArrayList<SHORT_LOG_ENTRY>();
        if (logFilteringParameters.isCollapseRepeatedEntries()) {
            logEntries.addAll(index.getCollapsedEntries(minLogLevel, startTimestamp, endTimestamp, logFilteringParameters.getOldestTimestamp(), newestEntriesFirst));
        } else {
            logEntries.addAll(index.getEntries(minLogLevel, startTimestamp, endTimestamp, newestEntriesFirst));
        }
        logEntries = LogServiceUtils.filterEntries(logFilteringParameters, index, logEntries);
        return logEntries;
    }

    public static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> ShortLogResponse<SHORT_LOG_ENTRY> getShortLogs(LogFilteringParameters logFilteringParameters, LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index) throws StorageException {
        List<SHORT_LOG_ENTRY> logEntries = LogServiceUtils.getShortLogsWithoutSortAndTruncate(logFilteringParameters, index);
        boolean newestEntriesFirst = LogServiceUtils.shouldSortByNewestEntriesFirst(logFilteringParameters);
        return new ShortLogResponse<SHORT_LOG_ENTRY>(logEntries.size(), LogServiceUtils.sortAndTruncateResult(logEntries, logFilteringParameters.getMaxResults(), newestEntriesFirst), index.haveLogsBeenTruncated());
    }

    private static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> boolean detailedLogMatches(LogEntryIdentifier id, Pattern filterPattern, LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index) {
        try {
            DETAILED_LOG_ENTRY detailedLog = index.getDetailedLog(id);
            if (detailedLog == null) {
                return false;
            }
            return detailedLog.matches(filterPattern);
        }
        catch (StorageException e) {
            return false;
        }
    }

    private static boolean shouldSortByNewestEntriesFirst(LogFilteringParameters logFilteringParameters) {
        return logFilteringParameters.getStartTimestamp() > logFilteringParameters.getEndTimestamp();
    }

    private static <SHORT_LOG_ENTRY extends ShortLogEntryBase> List<SHORT_LOG_ENTRY> filterEntries(LogFilteringParameters logFilteringParameters, LogIndexesWrapper<SHORT_LOG_ENTRY, ?> index, List<SHORT_LOG_ENTRY> logEntries) {
        String filterRegex = logFilteringParameters.getFilterRegex();
        if (StringUtils.isEmpty((String)filterRegex)) {
            return logEntries;
        }
        Pattern filterPattern = Pattern.compile(filterRegex, 2);
        boolean includeMatches = logFilteringParameters.isIncludeMatches();
        boolean searchDetailedLogs = logFilteringParameters.isSearchDetailedLogs();
        Predicate<ShortLogEntryBase> filter = logEntry -> (logEntry.matches(filterPattern) || searchDetailedLogs && LogServiceUtils.detailedLogMatches(logEntry.getId(), filterPattern, index)) == includeMatches;
        return CollectionUtils.filter(logEntries, filter);
    }

    private static <T extends LogEntryBase> List<T> sortAndTruncateResult(List<T> logEntries, int maxResults, boolean sortNewestToTop) {
        if (sortNewestToTop) {
            Collections.sort(logEntries, Collections.reverseOrder());
        } else {
            Collections.sort(logEntries);
        }
        if (maxResults > 0 && logEntries.size() > maxResults) {
            logEntries = logEntries.subList(0, maxResults);
        }
        return new ArrayList<T>(logEntries);
    }

    public static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> DETAILED_LOG_ENTRY getDetailedLogEntry(LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index, LogEntryIdentifier id) throws StorageException {
        return (DETAILED_LOG_ENTRY)((DetailedLogEntryBase)Optional.ofNullable(index.getDetailedLog(id)).orElseThrow(() -> new BadRequestException("Tried to load a detailed log that does not exist for timestamp " + id.timestamp())));
    }

    public static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> List<ProjectLogLevelFrequencies> obtainFrequencies(LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index) throws StorageException {
        ArrayList<ProjectLogLevelFrequencies> result = new ArrayList<ProjectLogLevelFrequencies>();
        PairList<PublicProjectId, LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY>> allProjectsAndIndexes = index.getAllProjectsAndIndexes();
        for (Pair pair : allProjectsAndIndexes) {
            PublicProjectId project = (PublicProjectId)pair.getFirst();
            int[] frequencies = ((LogIndexBase)pair.getSecond()).getLogLevelFrequencies();
            result.add(new ProjectLogLevelFrequencies(project, frequencies));
        }
        return result;
    }

    public static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> determineIndexForProject(PublicProjectId project, IndexLayer indexLayer, FunctionWithException<IndexLayer, LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY>, StorageException> globalIndexProvider, BiFunctionWithException<IndexLayer, PublicProjectId, LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY>, StorageException> projectIndexProvider) throws StorageException {
        Preconditions.checkNotNull((Object)project);
        if (SchedulingConstants.isMaintenance((IProjectId)project)) {
            return (LogIndexBase)globalIndexProvider.apply((Object)indexLayer);
        }
        return (LogIndexBase)projectIndexProvider.apply((Object)indexLayer, (Object)project);
    }

    public static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> Response createLogDownload(String filename, LogFilteringParameters logFilteringParameters, int maxChars, LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index) throws StorageException {
        StreamingOutput streamingOutput = LogServiceUtils.getStreamingLogOutputFromIndex(logFilteringParameters, maxChars, index);
        return ResponseUtils.getFileDownloadResponse(streamingOutput, MediaType.TEXT_PLAIN_TYPE, filename + ".txt");
    }

    public static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> StreamingOutput getStreamingLogOutputFromIndex(LogFilteringParameters logFilteringParameters, int maxChars, LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index) throws StorageException {
        List<SHORT_LOG_ENTRY> shortEventLogs = LogServiceUtils.getShortLogs(logFilteringParameters, index).getLogEntries();
        return LogServiceUtils.getStreamingLogOutputFromLogEntries(shortEventLogs, index, logFilteringParameters, maxChars);
    }

    private static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> StreamingOutput getStreamingLogOutputFromLogEntries(List<SHORT_LOG_ENTRY> shortEventLogs, LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index, LogFilteringParameters logFilteringParameters, int maxChars) {
        return output -> LogServiceUtils.writeToOutputStream(shortEventLogs, index, logFilteringParameters, maxChars, output);
    }

    private static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> void writeToOutputStream(List<SHORT_LOG_ENTRY> shortEventLogs, LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index, LogFilteringParameters logFilteringParameters, int maxChars, OutputStream output) throws IOException {
        PrintWriter writer = LogServiceUtils.getPrintWriter(output, maxChars);
        writer.print(LogServiceUtils.printFiltersToCommentLine(logFilteringParameters.getMaxResults(), maxChars, logFilteringParameters.getStartTimestamp(), logFilteringParameters.getEndTimestamp(), LogServiceUtils.shouldSortByNewestEntriesFirst(logFilteringParameters), logFilteringParameters.getFilterRegex(), logFilteringParameters.isIncludeMatches()));
        for (ShortLogEntryBase entry : shortEventLogs) {
            writer.write(entry.getFormattedLogEntry());
            writer.println();
            try {
                DETAILED_LOG_ENTRY details = index.getDetailedLog(entry.getId());
                if (details == null) continue;
                Iterator eventsIterator = details.getFormattedLogEntry().iterator();
                boolean hadEntry = false;
                while (eventsIterator.hasNext()) {
                    writer.println((String)eventsIterator.next());
                    hadEntry = true;
                }
                if (!hadEntry) continue;
                writer.println();
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
        }
        writer.flush();
    }

    private static PrintWriter getPrintWriter(OutputStream outputStream, int maxChars) {
        BufferedWriter internalWriter = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        if (maxChars > 0) {
            return new PrintWriter((Writer)new LimitedWriter((Writer)internalWriter, maxChars));
        }
        return new PrintWriter(internalWriter);
    }

    private static String printFiltersToCommentLine(int maxResults, int maxChars, long start, long end, boolean newestEntriesFirst, String regex, boolean included) {
        String sortingString = newestEntriesFirst ? "newest first" : "oldest first";
        String includedString = included ? "included" : "excluded";
        Object regexString = regex + " (matching entries are " + includedString + ")";
        if (StringUtils.isEmpty((String)regex)) {
            regexString = "none (all entries match)";
        }
        String maxResultsString = String.valueOf(maxResults);
        if (maxResults <= 0) {
            maxResultsString = "unlimited";
        }
        String maxCharsString = String.valueOf(maxChars);
        if (maxChars <= 0) {
            maxCharsString = "unlimited";
        }
        if (start > end) {
            long swap = end;
            end = start;
            start = swap;
        }
        return "Filters: Max results: " + maxResultsString + ", max characters: " + maxCharsString + ", start date " + String.valueOf(new Date(start)) + " (timestamp " + start + "), oldest date: " + String.valueOf(new Date(end)) + " (timestamp " + end + "), sorting: " + sortingString + ", regex: " + (String)regexString + "\n";
    }

    private LogServiceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

