/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.lang.ToStringHelpers;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.version.Version;
import org.jspecify.annotations.Nullable;

public final class ServiceApiInfo {
    private static final String MAX_API_VERSION_PROPERTY = "maxApiVersion";
    private static final String MIN_API_VERSION_PROPERTY = "minApiVersion";
    private static final String ADMIN_CONTACT_PROPERTY = "adminContact";
    @JsonProperty(value="maxApiVersion")
    private final Version maxApiVersion;
    @JsonProperty(value="minApiVersion")
    private final Version minApiVersion;
    @JsonProperty(value="adminContact")
    private final @Nullable String adminContact;

    @JsonCreator
    public ServiceApiInfo(@JsonProperty(value="maxApiVersion") Version maxApiVersion, @JsonProperty(value="minApiVersion") Version minApiVersion, @JsonProperty(value="adminContact") String adminContact) {
        Objects.requireNonNull(maxApiVersion);
        Objects.requireNonNull(minApiVersion);
        this.maxApiVersion = maxApiVersion;
        this.minApiVersion = minApiVersion;
        this.adminContact = adminContact;
    }

    public Version getMaxApiVersion() {
        return this.maxApiVersion;
    }

    public Version getMinApiVersion() {
        return this.minApiVersion;
    }

    public Optional<String> getAdminContact() {
        return Optional.ofNullable(this.adminContact);
    }

    public boolean isSupported(Version requiredVersion) {
        return requiredVersion.isSatisfied(this.maxApiVersion, this.minApiVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceApiInfo that = (ServiceApiInfo)o;
        return Objects.equals(this.maxApiVersion, that.maxApiVersion) && Objects.equals(this.minApiVersion, that.minApiVersion) && Objects.equals(this.adminContact, that.adminContact);
    }

    public int hashCode() {
        return Objects.hash(this.maxApiVersion, this.minApiVersion, this.adminContact);
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper(this).toString();
    }
}

