/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.service.testimpact.prioritization.ETestSelectionReason;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PrioritizableTestCluster
extends PrioritizableTestBase {
    private static final long serialVersionUID = 1L;
    private static final String CLUSTER_ID_PROPERTY = "clusterId";
    private static final String TESTS_PROPERTY = "tests";
    @JsonProperty(value="clusterId")
    private final String clusterId;
    @JsonProperty(value="tests")
    private final List<PrioritizableTest> tests;

    @JsonCreator
    private PrioritizableTestCluster(@JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="tests") List<PrioritizableTest> tests) {
        super(tests.stream().flatMap(test -> test.getChangedMethodLocations().stream()).collect(Collectors.toSet()));
        this.clusterId = clusterId;
        this.tests = new ArrayList<PrioritizableTest>(tests);
    }

    public static PrioritizableTestCluster create(String clusterId, List<PrioritizableTest> tests) {
        return new PrioritizableTestCluster(clusterId, tests);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public List<PrioritizableTest> getTests() {
        return Collections.unmodifiableList(this.tests);
    }

    public void updateTestsInCluster(List<PrioritizableTest> tests, Set<MethodId> methodsToTest) {
        this.tests.clear();
        this.tests.addAll(tests);
        this.durationInMs = null;
        this.coveredChangedMethods.clear();
        this.initAdditionallyCoveredMethods(methodsToTest);
        this.coveredMethods = this.tests.stream().flatMap(test -> test.getCoveredMethods().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<ETestSelectionReason> getSelectionReasons() {
        return this.tests.stream().flatMap(test -> test.getSelectionReasons().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<MethodId> getCoveredMethods() {
        if (this.coveredMethods == null) {
            this.coveredMethods = this.tests.stream().flatMap(test -> test.getCoveredMethods().stream()).collect(Collectors.toSet());
        }
        return this.coveredMethods;
    }

    @Override
    public Optional<Long> getDurationInMs() {
        if (this.durationInMs == null) {
            this.durationInMs = 0L;
            for (PrioritizableTest test : this.tests) {
                this.durationInMs = this.durationInMs + test.getDurationInMs(10000L);
            }
        }
        return Optional.of(this.durationInMs);
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper(this).toString();
    }

    @Override
    public String getIdentifier() {
        return this.clusterId;
    }
}

