/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.lang.ToStringHelpers;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.TrackedFinding;
import org.jspecify.annotations.Nullable;

public class PreCommit3Result {
    @JsonProperty(value="token")
    private final @Nullable String token;
    @JsonProperty(value="detailedErrors")
    public final @Nullable List<PreCommit3ErrorDetail> detailedErrors;
    @JsonProperty(value="findings")
    public final @Nullable List<TrackedFinding> findings;

    @JsonCreator
    public PreCommit3Result(@JsonProperty(value="token") @Nullable String token, @JsonProperty(value="detailedErrors") @Nullable List<PreCommit3ErrorDetail> detailedErrors, @JsonProperty(value="findings") @Nullable List<TrackedFinding> findings) {
        this.token = token;
        this.detailedErrors = detailedErrors;
        this.findings = findings;
    }

    public @Nullable String getToken() {
        return this.token;
    }

    public static final class PreCommit3ErrorDetail {
        @JsonProperty(value="type")
        public final String type;
        @JsonProperty(value="message")
        public final String message;
        @JsonProperty(value="affectedUniformPath")
        public final @Nullable String affectedUniformPath;
        @JsonProperty(value="resultsInvalid")
        public final boolean resultsInvalid;

        @JsonCreator
        private PreCommit3ErrorDetail(@JsonProperty(value="type") String type, @JsonProperty(value="message") String message, @JsonProperty(value="affectedUniformPath") @Nullable String affectedUniformPath, @JsonProperty(value="resultsInvalid") boolean resultsInvalid) {
            this.type = Objects.requireNonNull(type);
            this.message = Objects.requireNonNull(message);
            this.affectedUniformPath = affectedUniformPath;
            this.resultsInvalid = resultsInvalid;
        }

        public boolean isFileIndependentAbortionError() {
            return this.resultsInvalid && this.affectedUniformPath == null;
        }

        public static PreCommit3ErrorDetail createFileIndependentError(EPrecommit3ErrorType type, String message, boolean analysisAborted) {
            return new PreCommit3ErrorDetail(type.toString(), message, null, analysisAborted);
        }

        public static PreCommit3ErrorDetail createErrorForFile(EPrecommit3ErrorType type, String message, String affectedUniformPath, boolean analysisAborted) {
            return new PreCommit3ErrorDetail(type.toString(), message, affectedUniformPath, analysisAborted);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            PreCommit3ErrorDetail that = (PreCommit3ErrorDetail)other;
            return this.resultsInvalid == that.resultsInvalid && Objects.equals(this.type, that.type) && Objects.equals(this.message, that.message) && Objects.equals(this.affectedUniformPath, that.affectedUniformPath);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.message, this.affectedUniformPath, this.resultsInvalid);
        }

        public String toString() {
            return ToStringHelpers.toReflectiveStringHelper(this).toString();
        }
    }

    public static enum EPrecommit3ErrorType {
        PRECOMMIT_COMMIT_ANALYSIS_DISABLED_ON_SERVER,
        FILE_COUNT_LIMIT,
        FILE_SIZE_LIMIT,
        USER_TIME_LIMIT,
        TEAMSCALE_LICENSE_ERROR,
        PRECOMMIT_BRANCH_NOT_AVAILABLE_DURING_POLL,
        FILE_EXCLUDED_BY_PROJECT_CONFIGURATION,
        NO_VALID_CONNECTOR,
        ANALYSIS_NOT_LIVE,
        BRANCH_UNKNOWN;

    }
}

