/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.uniformpath;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class UniformPathCompatibilityUtil {
    public static UniformPath convert(String uniformPath) {
        return UniformPath.ofSegments(UniformPathCompatibilityUtil.getAbsoluteSegments(uniformPath));
    }

    public static UniformPath convert(UniformPath.EType type, String uniformPath) {
        return UniformPath.ofSegments(type, UniformPathCompatibilityUtil.getAbsoluteSegments(uniformPath));
    }

    public static RelativeUniformPath convertRelative(String uniformPath) {
        Preconditions.checkNotNull((Object)uniformPath, (Object)"Uniform path must not be null");
        return RelativeUniformPath.of(UniformPathUtils.splitPath(uniformPath.trim()));
    }

    static List<String> getAbsoluteSegments(String uniformPath) {
        Preconditions.checkNotNull((Object)uniformPath, (Object)"Uniform path must not be null");
        return RelativeUniformPath.resolveRelativeSegments(Arrays.asList(UniformPathUtils.splitPath(uniformPath.trim())));
    }

    public static List<UniformPath> convertCollection(Collection<String> uniformPaths) {
        return CollectionUtils.map(uniformPaths, UniformPathCompatibilityUtil::convert);
    }

    public static Set<UniformPath> convertSet(Collection<String> uniformPaths) {
        return CollectionUtils.mapToSet(uniformPaths, UniformPathCompatibilityUtil::convert);
    }

    public static List<String> asUniformPathStrings(Collection<UniformPath> uniformPaths) {
        return CollectionUtils.map(uniformPaths, UniformPath::toString);
    }

    public static Set<String> asUniformPathStringSet(Collection<UniformPath> uniformPaths) {
        return CollectionUtils.mapToSet(uniformPaths, UniformPath::toString);
    }

    public static <T> PairList<String, T> convertPairList(PairList<UniformPath, T> pairList) {
        return pairList.mapFirst(UniformPath::toString);
    }

    public static Map<UniformPath, String> createPathMapping(Collection<String> uniformPaths) {
        return uniformPaths.stream().distinct().collect(Collectors.toMap(UniformPathCompatibilityUtil::convert, Function.identity()));
    }

    public static String resolveToCodePath(String uniformPath) {
        return UniformPathCompatibilityUtil.convert(uniformPath).resolveToCodePath().toString();
    }

    public static boolean isRootPath(String uniformPath) {
        return UniformPath.parse(uniformPath).isRoot();
    }

    private UniformPathCompatibilityUtil() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

