/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.backup;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.backup.BackupLocationInfo;
import com.teamscale.index.backup.tempfile.TemporaryFileIndexBackupTarget;
import com.teamscale.index.backup.write.BackupExportOptions;
import com.teamscale.index.backup.write.BackupExportStatus;
import com.teamscale.index.backup.write.BackupExportStatusIndex;
import com.teamscale.index.backup.write.BackupExportTrigger;
import com.teamscale.index.backup.write.EBackupExportExcludeOptions;
import com.teamscale.service.admin.backup.BackupExportJobService;
import com.teamscale.service.admin.backup.BackupExportParameters;
import com.teamscale.service.admin.backup.BackupExportSummaryService;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class BackupExportService
extends ApiBase {
    @Context
    ResourceContext context;

    @POST
    @RequiresNoPermission(description="The user needs to have the permission to export global data provided the backup contains any and the permission to backup project data for all projects contained in the backup.")
    @Operation(summary="Export backup.", description="Triggers the creation of a backup and returns its ID.", tags={"Backup"}, responses={@ApiResponse(responseCode="403", description="The user is authenticated, but does not have the necessary permissions to access the endpoint."), @ApiResponse(responseCode="400", description="include-projects param has to be empty if include-all-visible-projects is set to true")})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_1_0, deprecatedSince=ETeamscaleVersion.VERSION_2024_8_0)
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String createBackupWithIncludeParameters(@BeanParam BackupExportParameters exportParameters, @FormParam(value="include-pending-external-upload-sessions") @DefaultValue(value="true") boolean includePendingExternalUploadSessions, @FormParam(value="include-git-labeling-info") @DefaultValue(value="true") boolean includeGitLabelingInfo) throws StorageException {
        HashSet<EBackupExportExcludeOptions> exportExcludeOptions = new HashSet<EBackupExportExcludeOptions>();
        if (!includePendingExternalUploadSessions) {
            exportExcludeOptions.add(EBackupExportExcludeOptions.EXTERNAL_ANALYSIS_SESSIONS);
        }
        if (!includeGitLabelingInfo) {
            exportExcludeOptions.add(EBackupExportExcludeOptions.GIT_LABELING);
        }
        exportParameters.setExportExcludeOptions(exportExcludeOptions);
        return this.createBackup(exportParameters);
    }

    @POST
    @RequiresNoPermission(description="The user needs to have the permission to export global data provided the backup contains any and the permission to backup project data for all projects contained in the backup.")
    @Operation(summary="Export backup.", description="Triggers the creation of a backup and returns its ID.", tags={"Backup"}, responses={@ApiResponse(responseCode="403", description="The user is authenticated, but does not have the necessary permissions to access the endpoint."), @ApiResponse(responseCode="400", description="include-projects param has to be empty if include-all-visible-projects is set to true")})
    @PublicApi(since=ETeamscaleVersion.VERSION_2024_8_0)
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String createBackup(@BeanParam BackupExportParameters exportParameters) throws StorageException {
        Set<PublicProjectId> includedProjects = this.getIncludedProjects(exportParameters);
        boolean includeGlobalData = exportParameters.isIncludeGlobalData();
        this.getPermissions().checkBackupPermissions(includeGlobalData, includedProjects);
        String backupPath = exportParameters.getBackupPath();
        String id = BackupExportService.determineId(includeGlobalData, includedProjects);
        backupPath = BackupExportService.buildBackupPath(backupPath, id);
        BackupExportOptions exportOptions = new BackupExportOptions().setExportGlobalData(includeGlobalData).setBackupTarget(backupPath);
        includedProjects.forEach(arg_0 -> ((BackupExportOptions)exportOptions).addIncludedProject(arg_0));
        exportOptions.setExportExcludeOptions(exportParameters.getExportExcludeOptions());
        exportParameters.getExternalUploadExportOption().forEach(arg_0 -> ((BackupExportOptions)exportOptions).addExternalUploadExportOption(arg_0));
        this.openGlobalIndex(BackupExportStatusIndex.class).setStatus(id, new BackupExportStatus(exportOptions));
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), new JobDescriptor(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, BackupExportTrigger.class, null, (Object)id, "Scheduled due to backup export '" + id + "'."));
        AuditLogs.backupCreated((String)id);
        return id;
    }

    private Set<PublicProjectId> getIncludedProjects(BackupExportParameters exportParameters) throws StorageException {
        HashSet<PublicProjectId> includedProjects = new HashSet();
        if (exportParameters.isIncludeAllVisibleProjects()) {
            if (!exportParameters.getIncludedProjects().isEmpty()) {
                throw new BadRequestException("include-projects param has to be empty if include-all-visible-projects is set to true");
            }
            ProjectIndex projectIndex = this.getIndexLayer().openProjectIndex();
            for (PublicProjectId projectId : projectIndex.getAllPrimaryPublicProjectIds()) {
                if (!this.getPermissions().userHasProjectPermission((IProjectId)projectId, EProjectPermission.BACKUP_DATA)) continue;
                includedProjects.add(projectId);
            }
        } else {
            includedProjects = exportParameters.getIncludedProjects();
        }
        return includedProjects;
    }

    private static String buildBackupPath(String backupPath, String id) {
        if (StringUtils.isEmpty((String)backupPath)) {
            backupPath = TemporaryFileIndexBackupTarget.buildURI((String)id).toString();
        } else {
            backupPath = backupPath.trim();
            try {
                Path path = Paths.get(backupPath, new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    backupPath = FileSystemUtils.concatenatePaths((String)backupPath, (String[])new String[]{id});
                }
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        return backupPath;
    }

    private static String determineId(boolean includeGlobalData, Set<PublicProjectId> includedProjects) {
        String date = LocalDateTime.now().format(BackupLocationInfo.BACKUP_DATE_TIME_FORMATTER);
        String prefix = "teamscale";
        if (includedProjects.size() == 1 && !includeGlobalData) {
            prefix = Objects.requireNonNull((PublicProjectId)CollectionUtils.getAny(includedProjects)).toString();
        }
        return prefix + "-backup_" + date;
    }

    @jakarta.ws.rs.Path(value="{backupId}")
    public BackupExportJobService getJobService(@Parameter(description="The backup ID.", required=true) @PathParam(value="backupId") String backupId) {
        return (BackupExportJobService)this.context.initResource((Object)new BackupExportJobService(backupId));
    }

    @jakarta.ws.rs.Path(value="summary")
    public Class<BackupExportSummaryService> getSummariesService() {
        return BackupExportSummaryService.class;
    }
}

