/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.ai;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.LlmPrompt;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.resource.TokenElementServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/ai/{engine}/content")
public class TokenElementAiService
extends ApiBase {
    @GET
    @Operation(summary="Get an AI generated summary for an element", description="Retrieves the AI summary for an element.", tags={"Source Code"})
    @Path(value="summary")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public String getAiSummary(@Parameter(description="The interal name of the configured AI engine to use.") @PathParam(value="engine") String engine, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to obtain the token element info for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException, ServiceCallException {
        TokenElementInfo element = TokenElementServiceUtils.retrieveElement(uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), this.determineHistoryOption(commit));
        if (element == null) {
            throw new NotFoundException();
        }
        String prompt = "Summarize the content of the following code file, which is named '" + element.getUniformPath() + "'. Be brief about it.";
        return this.serviceInfo.getAiEngineProvider().complete(engine, new LlmPrompt(prompt, new String[]{element.getText()}));
    }
}

