/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/auth/servers")
public class ServerListService
extends ApiBase {
    @GET
    @Operation(summary="Get authentication servers", description="List configured authentication servers.", tags={"Administration", "Users", "Groups"})
    @RequiresComplexPermission(value=EComplexPermission.MAY_VIEW_AUTHENTICATION_SERVERS)
    public Map<String, List<String>> getAvailableServers() throws StorageException {
        HashMap<String, List<String>> serverLists = new HashMap<String, List<String>>();
        for (EAuthenticationTool serverType : EAuthenticationTool.values()) {
            if (!serverType.isExternal()) continue;
            IAuthenticationToolProvider toolProvider = AuthenticationToolUtils.getProvider((EAuthenticationTool)serverType, (GlobalStorageSystem)this.getGlobalStorageSystem(), (IMessageBroker)this.serviceInfo.getMessageBroker());
            serverLists.put(serverType.name().toLowerCase(), toolProvider.getServerList());
        }
        return serverLists;
    }
}

