/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.analysis_profile;

import com.teamscale.service.documentation.DocumentationNodeBase;
import com.teamscale.service.documentation.layout.Layouter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class OptionDocumentation
extends DocumentationNodeBase<OptionDocumentation> {
    private static final Pattern THRESHOLD_VALUES_PATTERN = Pattern.compile("\\{\"yellowThreshold\":\"(?<yellow>\\d+)\",\"redThreshold\":\"(?<red>\\d+)\"\\}");
    private static final Pattern TIDY_OPTION_NAME_PATTERN = Pattern.compile("^[\\s:-]+(.*)");
    private String value;

    public OptionDocumentation(String optionName, String description, String checkName, String value) {
        super(OptionDocumentation.tidyOptionName(optionName, checkName), description);
        this.value = OptionDocumentation.tidyValue(value);
    }

    @Override
    protected List<OptionDocumentation> getChildren() {
        return CollectionUtils.emptyList();
    }

    @Override
    protected void layoutStart(Layouter layouter) {
        layouter.appendBullet(layouter.escape(this.readableName), 1);
        if (!StringUtils.isEmpty((String)this.description)) {
            layouter.append(" ");
            layouter.appendItalic("(" + StringUtils.stripSuffix((String)this.description, (String)".") + ")");
        }
        layouter.append(": ");
        Matcher thresholdValuesMatcher = THRESHOLD_VALUES_PATTERN.matcher(this.value);
        if (thresholdValuesMatcher.matches()) {
            layouter.appendColorized("YELLOW", ETrafficLightColor.YELLOW);
            layouter.append(" if threshold of ");
            layouter.appendBold(thresholdValuesMatcher.group("yellow"));
            layouter.append(" is violated, ");
            layouter.appendColorized("RED", ETrafficLightColor.RED);
            layouter.append(" if threshold of ");
            layouter.appendBold(thresholdValuesMatcher.group("red"));
            layouter.append(" is violated");
            layouter.appendNewLine();
        } else {
            layouter.appendBold(layouter.escape(this.value));
            layouter.appendNewLine();
        }
    }

    private static String tidyValue(String value) {
        if (value.equals(Boolean.TRUE.toString())) {
            return "Yes";
        }
        if (value.equals(Boolean.FALSE.toString())) {
            return "No";
        }
        return value;
    }

    private static String tidyOptionName(String optionName, String checkName) {
        if (checkName == null) {
            return optionName;
        }
        String tidyName = StringUtils.stripPrefix((String)optionName, (String)checkName);
        return StringUtils.replaceFirst((String)tidyName, (Pattern)TIDY_OPTION_NAME_PATTERN, (String)"$1");
    }
}

